/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.MergeRecordEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IMergeRecordService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.MergeRecordVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mergeRecord"})
public class MergeRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IMergeRecordService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MergeRecordVO> saveOrUpdate(@RequestBody MergeRecordVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.insertOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MergeRecordVO> queryDetail(Long id) {
        MergeRecordEntity entity = (MergeRecordEntity)((Object)this.service.selectById(id));
        MergeRecordVO vo = (MergeRecordVO)BeanMapper.map((Object)((Object)entity), MergeRecordVO.class);
        LambdaQueryWrapper payRecordEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        payRecordEntityLambdaQueryWrapper.eq(PayRecordEntity::getMergeConfirmId, (Object)entity.getId());
        List list = this.payRecordService.list((Wrapper)payRecordEntityLambdaQueryWrapper);
        vo.setPayRecordVOList(BeanMapper.mapList((Iterable)list, PayRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushVoucher"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull((Object)billId, (String)"\u5355\u636ebillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MergeRecordEntity entity = (MergeRecordEntity)((Object)this.service.selectById(billId));
        String bussinesType = "\u5408\u5e76\u652f\u4ed8";
        Map recordMap = DataConvertUtil.objToMap((Object)((Object)entity));
        LambdaQueryWrapper payRecordEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        payRecordEntityLambdaQueryWrapper.eq(PayRecordEntity::getMergeConfirmId, (Object)entity.getId());
        List list = this.payRecordService.list((Wrapper)payRecordEntityLambdaQueryWrapper);
        PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(((PayRecordEntity)((Object)list.get(0))).getPayapplyId()));
        PayContractVO payContractVoucherVO = (PayContractVO)BeanMapper.map((Object)((Object)contract), PayContractVO.class);
        payContractVoucherVO.setId(entity.getId());
        payContractVoucherVO.set_payRecordId(recordMap);
        payContractVoucherVO.setPayMny(BigDecimal.ZERO);
        payContractVoucherVO.getCustomField().put("DLFY", entity.getDLFY());
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200611000000017", (Object)payContractVoucherVO, (String)bussinesType, (SystemCodeEnum)SystemCodeEnum.FINANCE);
        CommonResponse response = this.voucherApi.handleVoucher(voucherParams, "save");
        VoucherInfo voucherInfoRes = (VoucherInfo)response.getData();
        if (voucherInfoRes != null) {
            Integer voucherFlag = voucherInfoRes.getVoucherFlag();
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)billId);
            String voucherInfoStr = DataConvertUtil.objToString((Object)voucherInfoRes);
            updateWrapper.set((Object)"voucher_flag", (Object)voucherFlag);
            updateWrapper.set((Object)"voucher_info", (Object)voucherInfoStr);
            this.service.update((Wrapper)updateWrapper);
        }
        return response;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MergeRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MergeRecordVO mergeRecordVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MergeRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "employeeName", "contractName", "orgName", "memo", "receiveUnitName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MergeRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "employeeName", "contractName", "orgName", "memo", "receiveUnitName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MergeRecord-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMergeRecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MergeRecordVO>> refMergeRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MergeRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

