/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.mapper.DeductionMapper;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import jodd.util.StringUtil;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deductionService")
public class DeductionServiceImpl
extends BaseServiceImpl<DeductionMapper, DeductionEntity>
implements IDeductionService {
    @Autowired
    private DeductionMapper deductionMapper;
    private static final String INDEX_NAME_PAY_CONTRACT = "pay_contract";
    @Autowired(required=false)
    private RestHighLevelClient client;
    private static final Integer QUERY_TIMEOUT = 60;

    @Override
    public String querySupplierIds(Long projectId) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PAY_CONTRACT});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(0);
        sourceBuilder.size(10000);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        HashSet<Object> hashSet = new HashSet<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                JSONObject jsonObject = JSON.parseObject((String)sourceAsString);
                hashSet.add(jsonObject.get((Object)"supplierId"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String supplierIds = StringUtil.join(hashSet, (String)",");
        return supplierIds;
    }
}

