package com.ejianc.controller;

import com.ejianc.entity.DataTagFillEntity;
import com.ejianc.entity.Result;
import com.ejianc.util.GetDirPathUtil;
import com.ejianc.util.RemoteCallUtil;
import com.zhuozhengsoft.pageoffice.FileSaver;
import com.zhuozhengsoft.pageoffice.OpenModeType;
import com.zhuozhengsoft.pageoffice.PageOfficeCtrl;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping(value = "/doc")
public class DocumentController {


    @RequestMapping(value = "/editFile", method = org.springframework.web.bind.annotation.RequestMethod.POST)
    public String openFile(HttpServletRequest request, @RequestBody DataTagFillEntity dataTagFillEntity)  {
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);

        String fileType = dataTagFillEntity.getFileType();
        String fileName = dataTagFillEntity.getFileName();

        poCtrl.webOpen("file://" + GetDirPathUtil.getDirPath() + fileName, OpenModeType.docNormalEdit, "Luna");

        try {
            // 准备请求数据
            String url = "http://localhost:8080/dataTagfill/fill";
            Map<String, String> headers = new HashMap<>();
            headers.put("Authorization", "Bearer token123");
            headers.put("Content-Type", "application/json");

            Result<Long> result = RemoteCallUtil.doPost(url, dataTagFillEntity, headers, Long.class);
            if (result.isSuccess()) {
                return poCtrl.getHtml();
            } else {
                throw new RuntimeException("编辑文件失败: " + result.getMsg());
            }

        } catch (RemoteCallUtil.RemoteCallException e) {
            e.printStackTrace();
        }
        return poCtrl.getHtml();
    }

    @RequestMapping(value = "/saveFile",method = org.springframework.web.bind.annotation.RequestMethod.POST)
    public void saveFile(HttpServletRequest request, HttpServletResponse response,@RequestParam String file_name) {
        FileSaver fs = new FileSaver(request, response);
        //fs.saveToFile(dir + file_name);
        fs.close();
    }
}



