package com.ejianc.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * 统一返回体
 * @param <T> 数据类型
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Result<T> {
    private int code;       // 状态码
    private String msg;     // 消息
    private T data;         // 数据

    // 私有构造方法，强制使用静态工厂方法创建实例
    private Result(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    // 成功静态工厂方法
    public static <T> Result<T> success(T data) {
        return new Result<>(200, "success", data);
    }

    public static <T> Result<T> success() {
        return success(null);
    }

    // 失败静态工厂方法
    public static <T> Result<T> error(int code, String msg) {
        return new Result<>(code, msg, null);
    }

    public static <T> Result<T> error(String msg) {
        return error(500, msg);
    }

    // getter方法
    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public T getData() {
        return data;
    }

    // 判断是否成功
    public boolean isSuccess() {
        return code == 200;
    }
}