/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class GetDirPathUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDirPath() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource resource = resolver.getResource("classpath*:");
        URI uri = null;
        try {
            uri = resource.getURI();
            if (uri.getScheme().equals("file")) {
                File classpathRoot = new File(uri);
                File targetDir = new File(classpathRoot.getParentFile().getParentFile(), "target/classes");
                if (!targetDir.exists()) return null;
                return targetDir.getAbsolutePath();
            }
            if (!uri.getScheme().equals("jar")) return null;
            try (InputStream in = resource.getInputStream();){
                Path tempDir = Files.createTempDirectory("jar-resources", new FileAttribute[0]);
                Path tempFile = tempDir.resolve("temp-resource");
                Files.copy(in, tempFile, new CopyOption[0]);
                String string = tempDir.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

