/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.entity.TemplateCategoryEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.mapper.TemplateCategoryMapper;
import com.ejianc.vo.CategoryLevelVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"templateCategory"})
public class TemplateCategoryController {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;

    @PostMapping(value={"/categoryTree"})
    public CommonResponse<List<TemplateCategoryEntity>> categoryTree(@RequestBody(required=false) Map<String, Object> params) {
        QueryWrapper wrapper = new QueryWrapper();
        if (params != null && params.get("range") != null) {
            String range;
            switch (range = params.get("range").toString()) {
                case "selfOrg": {
                    wrapper.eq((Object)"belong_org_id", (Object)InvocationInfoProxy.getOrgId());
                    break;
                }
                case "selfAndBelow": {
                    if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                        wrapper.eq((Object)"belong_org_id", (Object)InvocationInfoProxy.getOrgId());
                        break;
                    }
                    CommonResponse orgVOListResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                    if (!orgVOListResp.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    List orgIds = ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                    if (orgIds.isEmpty()) break;
                    wrapper.in((Object)"belong_org_id", orgIds);
                    break;
                }
                case "parents": {
                    CommonResponse orgVOListResp = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                    if (!orgVOListResp.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    List orgIds = ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                    if (orgIds.isEmpty()) break;
                    wrapper.in((Object)"belong_org_id", orgIds);
                    break;
                }
            }
        }
        List dataList = this.templateCategoryMapper.selectList((Wrapper)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)dataList);
    }

    @GetMapping(value={"/categoryLevels"})
    public CommonResponse<List<CategoryLevelVO>> getCategoryLevels() {
        List<CategoryLevelVO> list = this.templateCategoryMapper.selectCategoryLevels();
        return CommonResponse.success((String)"\u67e5\u8be2\u591a\u7ea7\u5206\u7c7b\u6811\u6210\u529f\uff01", list);
    }
}

