/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.entity.TemplateEntity;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.service.ITemplateCategoryService;
import com.ejianc.service.ITemplateService;
import com.ejianc.vo.FileUploadResult;
import feign.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"template"})
public class TemplateController {
    private static final String BILL_CODE = "LJL_TEMPLATE";
    private static final String RPA_BASE_URL = "http://10.136.208.23:16106/";
    private static final String RPA_APP_KEY = "OL5E5raV";
    private static final String RPA_SECRET_KEY = "r7Oi2ITQee5OHuYCBAsShCD7wgP7xoqHJjr1lucr";
    private static final String RPA_TOKEN_URL = "/rpa/open/api/token/applyNoUser";
    private static final String RPA_UPLOAD_URL = "/rpa/api/upload/uploadFile";
    private static final String RPA_SUCCESS_CODE = "0000";
    private static final int RPA_TOKEN_TIMEOUT = 10000;
    private static final int RPA_UPLOAD_TIMEOUT = 30000;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateCategoryService categoryService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\uff08\u5c01\u88c5\u5199\u6cd5\uff09")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPage(@RequestBody Map<String, Object> params) {
        long current = Long.parseLong(params.get("pageIndex").toString());
        long size = Long.parseLong(params.get("pageSize").toString());
        Page page = new Page(current, size);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (params.containsKey("templateName") && StringUtils.isNotEmpty((String)((String)params.get("templateName")))) {
            queryWrapper.like(TemplateEntity::getTemplateName, params.get("templateName"));
        }
        if (params.containsKey("categoryId") && params.get("categoryId") != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, params.get("categoryId"));
        }
        if (params.containsKey("enableStatus") && params.get("enableStatus") != null) {
            queryWrapper.eq(TemplateEntity::getEnableStatus, params.get("enableStatus"));
        }
        if (params.containsKey("fileType") && StringUtils.isNotEmpty((String)((String)params.get("fileType")))) {
            queryWrapper.eq(TemplateEntity::getFileType, params.get("fileType"));
        }
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        IPage result = this.templateService.page((IPage)page, (Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @ApiOperation(value="\u590d\u6742\u67e5\u8be2\u6761\u4ef6\u7684\u539f\u751fMyBatis-Plus\u5199\u6cd5")
    @GetMapping(value={"/queryPageComplex"})
    @ResponseBody
    public CommonResponse<IPage<TemplateEntity>> queryPageComplex(@ApiParam(value="\u5f53\u524d\u9875", defaultValue="1") @RequestParam(defaultValue="1") long current, @ApiParam(value="\u6bcf\u9875\u5927\u5c0f", defaultValue="10") @RequestParam(defaultValue="10") long size, @ApiParam(value="\u6a21\u677f\u540d\u79f0\uff08\u6a21\u7cca\u67e5\u8be2\uff09") @RequestParam(required=false) String templateName, @ApiParam(value="\u5206\u7c7bID\uff08\u7cbe\u786e\u67e5\u8be2\uff09") @RequestParam(required=false) Long categoryId, @ApiParam(value="\u6587\u4ef6\u7c7b\u578b\u5217\u8868\uff08IN\u67e5\u8be2\uff09") @RequestParam(required=false) String[] fileTypes, @ApiParam(value="\u6700\u5c0f\u6587\u4ef6\u5927\u5c0f") @RequestParam(required=false) Integer minFileSize, @ApiParam(value="\u6700\u5927\u6587\u4ef6\u5927\u5c0f") @RequestParam(required=false) Integer maxFileSize) {
        Page page = new Page(current, size);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((String)templateName)) {
            queryWrapper.like(TemplateEntity::getTemplateName, (Object)templateName);
        }
        if (categoryId != null) {
            queryWrapper.eq(TemplateEntity::getCategoryId, (Object)categoryId);
        }
        if (fileTypes != null && fileTypes.length > 0) {
            queryWrapper.in(TemplateEntity::getFileType, (Object[])fileTypes);
        }
        if (minFileSize != null) {
            queryWrapper.ge(TemplateEntity::getFileSize, (Object)minFileSize);
        }
        if (maxFileSize != null) {
            queryWrapper.le(TemplateEntity::getFileSize, (Object)maxFileSize);
        }
        queryWrapper.eq(TemplateEntity::getEnableStatus, (Object)1);
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(BaseEntity::getCreateTime)).orderByAsc(TemplateEntity::getSequence);
        IPage result = this.templateService.page((IPage)page, (Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @ApiOperation(value="\u4f7f\u7528\u539f\u751fMyBatis-Plus\u7684selectMaps\u65b9\u6cd5\u8fdb\u884c\u7edf\u8ba1\u67e5\u8be2")
    @GetMapping(value={"/statistics"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getStatistics() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        long totalCount = this.templateService.count((Wrapper)queryWrapper);
        queryWrapper.select(new SFunction[]{TemplateEntity::getFileType, BaseEntity::getId});
        queryWrapper.groupBy((Object[])new SFunction[]{TemplateEntity::getFileType});
        LambdaQueryWrapper enabledWrapper = new LambdaQueryWrapper();
        enabledWrapper.eq(TemplateEntity::getEnableStatus, (Object)1);
        long enabledCount = this.templateService.count((Wrapper)enabledWrapper);
        HashMap<String, Long> statistics = new HashMap<String, Long>();
        statistics.put("totalCount", totalCount);
        statistics.put("enabledCount", enabledCount);
        statistics.put("disabledCount", totalCount - enabledCount);
        return CommonResponse.success((String)"\u7edf\u8ba1\u67e5\u8be2\u6210\u529f\uff01", statistics);
    }

    @RequestMapping(value={"/compareFilesById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<com.alibaba.fastjson.JSONObject> compareFilesById(@RequestParam(value="firstFileId") Long firstFileId, @RequestParam(value="secondFileId") Long secondFileId) {
        this.logger.info("\u5f00\u59cb\u6587\u4ef6\u5bf9\u6bd4\uff0c\u6587\u4ef6ID: {}, {}", (Object)firstFileId, (Object)secondFileId);
        try {
            CommonResponse<com.alibaba.fastjson.JSONObject> validationResult = this.validateParameters(firstFileId, secondFileId);
            if (!validationResult.isSuccess()) {
                return validationResult;
            }
            String openToken = this.getOpenToken();
            if (StringUtils.isBlank((String)openToken)) {
                return CommonResponse.error((String)"\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            }
            FileUploadResult firstFileResult = this.processFileUpload(firstFileId, "\u7b2c\u4e00\u4e2a\u6587\u4ef6");
            if (!firstFileResult.isSuccess()) {
                return CommonResponse.error((String)firstFileResult.getErrorMessage());
            }
            FileUploadResult secondFileResult = this.processFileUpload(secondFileId, "\u7b2c\u4e8c\u4e2a\u6587\u4ef6");
            if (!secondFileResult.isSuccess()) {
                return CommonResponse.error((String)secondFileResult.getErrorMessage());
            }
            com.alibaba.fastjson.JSONObject result = this.buildComparisonResult(openToken, firstFileResult, secondFileResult);
            this.logSuccess(firstFileId, secondFileId, firstFileResult, secondFileResult);
            return CommonResponse.success((String)"\u6587\u4ef6\u5bf9\u6bd4\u51c6\u5907\u6210\u529f", (Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u6587\u4ef6\u5bf9\u6bd4\u5904\u7406\u5931\u8d25\uff0c\u6587\u4ef6ID: {}, {}", new Object[]{firstFileId, secondFileId, e});
            return CommonResponse.error((String)("\u6587\u4ef6\u5bf9\u6bd4\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }

    private CommonResponse<com.alibaba.fastjson.JSONObject> validateParameters(Long firstFileId, Long secondFileId) {
        if (firstFileId == null || secondFileId == null) {
            return CommonResponse.error((String)"\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (firstFileId.equals(secondFileId)) {
            return CommonResponse.error((String)"\u4e0d\u80fd\u5bf9\u6bd4\u540c\u4e00\u4e2a\u6587\u4ef6");
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u901a\u8fc7", null);
    }

    private String getOpenToken() {
        try {
            String timestamp = System.currentTimeMillis() + "";
            String random = RandomUtil.randomString((int)12);
            String sign = MD5.create().digestHex(RPA_APP_KEY + timestamp + RPA_SECRET_KEY + random);
            com.alibaba.fastjson.JSONObject requestBody = new com.alibaba.fastjson.JSONObject().fluentPut("appKey", (Object)RPA_APP_KEY).fluentPut("timestamp", (Object)timestamp).fluentPut("random", (Object)random).fluentPut("sign", (Object)sign);
            this.logger.debug("\u8bf7\u6c42RPA\u8bbf\u95ee\u4ee4\u724c\uff0c\u53c2\u6570: {}", (Object)requestBody.toString());
            HttpResponse response = HttpRequest.post((String)"http://10.136.208.23:16106//rpa/open/api/token/applyNoUser").contentType(ContentType.JSON.getValue()).body(requestBody.toString()).timeout(10000).execute();
            return this.parseTokenResponse(response);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724c\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private FileUploadResult processFileUpload(Long fileId, String fileDescription) {
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(fileId);
            if (fileResponse == null || fileResponse.body() == null) {
                return FileUploadResult.failure(fileDescription + "\u65e0\u6cd5\u83b7\u53d6\uff0c\u6587\u4ef6ID: " + fileId);
            }
            CommonResponse attachmentResponse = this.attachmentApi.queryDetail(String.valueOf(fileId));
            if (!attachmentResponse.isSuccess() || attachmentResponse.getData() == null) {
                return FileUploadResult.failure(fileDescription + "\u8be6\u7ec6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u6587\u4ef6ID: " + fileId);
            }
            String fileName = ((AttachmentVO)attachmentResponse.getData()).getFileName();
            if (StringUtils.isBlank((String)fileName)) {
                return FileUploadResult.failure(fileDescription + "\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: " + fileId);
            }
            String rpaFileId = this.uploadToRPA(fileResponse, fileId, fileName);
            if (StringUtils.isBlank((String)rpaFileId)) {
                return FileUploadResult.failure(fileDescription + "\u4e0a\u4f20RPA\u5931\u8d25\uff0c\u6587\u4ef6ID: " + fileId);
            }
            return FileUploadResult.success(fileName, rpaFileId);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u6587\u4ef6\u4e0a\u4f20\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
            return FileUploadResult.failure(fileDescription + "\u5904\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    private com.alibaba.fastjson.JSONObject buildComparisonResult(String openToken, FileUploadResult firstFileResult, FileUploadResult secondFileResult) {
        String comparisonUrl = this.buildComparisonUrl(openToken, firstFileResult, secondFileResult);
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject();
        result.put("url", (Object)comparisonUrl);
        result.put("firstFileName", (Object)firstFileResult.getFileName());
        result.put("secondFileName", (Object)secondFileResult.getFileName());
        result.put("firstFileRpaId", (Object)firstFileResult.getRpaFileId());
        result.put("secondFileRpaId", (Object)secondFileResult.getRpaFileId());
        return result;
    }

    private void logSuccess(Long firstFileId, Long secondFileId, FileUploadResult firstFileResult, FileUploadResult secondFileResult) {
        this.logger.info("\u6587\u4ef6\u5bf9\u6bd4\u51c6\u5907\u5b8c\u6210\uff0c\u6587\u4ef6ID: {}, {}, RPA\u6587\u4ef6ID: {}, {}", new Object[]{firstFileId, secondFileId, firstFileResult.getRpaFileId(), secondFileResult.getRpaFileId()});
    }

    private String parseTokenResponse(HttpResponse response) {
        if (!response.isOk()) {
            this.logger.error("\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724cHTTP\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}", (Object)response.getStatus());
            return null;
        }
        String responseBody = response.body();
        this.logger.debug("RPA\u83b7\u53d6token\u54cd\u5e94: {}", (Object)responseBody);
        try {
            JSONObject jsonResponse = JSONUtil.parseObj((String)responseBody);
            if (RPA_SUCCESS_CODE.equals(jsonResponse.getStr((Object)"code"))) {
                JSONObject dataObj = jsonResponse.getJSONObject((Object)"data");
                if (dataObj != null) {
                    String openToken = dataObj.getStr((Object)"openToken");
                    if (StringUtils.isNotBlank((String)openToken)) {
                        this.logger.info("\u6210\u529f\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724c");
                        return openToken;
                    }
                    this.logger.error("RPA\u54cd\u5e94\u4e2dopenToken\u4e3a\u7a7a");
                } else {
                    this.logger.error("RPA\u54cd\u5e94\u4e2ddata\u5bf9\u8c61\u4e3a\u7a7a");
                }
            } else {
                this.logger.error("\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)jsonResponse.getStr((Object)"code"), (Object)jsonResponse.getStr((Object)"msg"));
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790RPA\u4ee4\u724c\u54cd\u5e94\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadToRPA(Response fileResponse, Long fileId, String fileName) {
        if (fileResponse == null || fileResponse.body() == null) {
            this.logger.error("\u6587\u4ef6\u54cd\u5e94\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: {}", (Object)fileId);
            return null;
        }
        if (StringUtils.isBlank((String)fileName)) {
            this.logger.error("\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: {}", (Object)fileId);
            return null;
        }
        InputStream inputStream = null;
        File tempFile = null;
        try {
            inputStream = fileResponse.body().asInputStream();
            if (inputStream == null) {
                this.logger.error("\u6587\u4ef6\u6d41\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: {}", (Object)fileId);
                String string = null;
                return string;
            }
            String token = this.getOpenToken();
            if (StringUtils.isBlank((String)token)) {
                this.logger.error("\u83b7\u53d6RPA\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25\uff0c\u6587\u4ef6ID: {}", (Object)fileId);
                String string = null;
                this.closeQuietly(inputStream);
                this.deleteQuietly(tempFile);
                return string;
            }
            tempFile = this.createTempFile(inputStream, fileName, fileId);
            if (tempFile == null) {
                String string = null;
                this.closeQuietly(inputStream);
                this.deleteQuietly(tempFile);
                return string;
            }
            String string = this.uploadFileToRPA(tempFile, token, fileId);
            this.closeQuietly(inputStream);
            this.deleteQuietly(tempFile);
            return string;
        }
        catch (IOException e) {
            this.logger.error("\u5904\u7406\u6587\u4ef6\u6d41\u65f6\u53d1\u751fIO\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
            String string = null;
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230RPA\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
            String string = null;
            return string;
        }
        finally {
            this.closeQuietly(inputStream);
            this.deleteQuietly(tempFile);
        }
    }

    private String buildComparisonUrl(String openToken, FileUploadResult firstFileResult, FileUploadResult secondFileResult) {
        return String.format("http://10.136.208.23:16106/app-aiservice/contract_comparision?openToken=%s&ignoreWatermark&ignoreSeal&basicFileId=%s&basicFileName=%s&targetFileId=%s&targetFileName=%s", openToken, firstFileResult.getRpaFileId(), firstFileResult.getFileName(), secondFileResult.getRpaFileId(), secondFileResult.getFileName());
    }

    private File createTempFile(InputStream inputStream, String fileName, Long fileId) {
        File tempFile = null;
        try {
            String extension = this.getFileExtension(fileName);
            tempFile = File.createTempFile(fileName, extension);
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
            }
            this.logger.debug("\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u6210\u529f\uff0c\u6587\u4ef6ID: {}, \u4e34\u65f6\u6587\u4ef6\u8def\u5f84: {}", (Object)fileId, (Object)tempFile.getAbsolutePath());
            return tempFile;
        }
        catch (IOException e) {
            this.logger.error("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
            this.deleteQuietly(tempFile);
            return null;
        }
    }

    private String uploadFileToRPA(File tempFile, String token, Long fileId) {
        try {
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)"http://10.136.208.23:16106//rpa/api/upload/uploadFile").header("Open-Token", token)).form("file", tempFile).timeout(30000).execute();
            return this.parseUploadResponse(response, fileId);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230RPA\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
            return null;
        }
    }

    private String getFileExtension(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            return ".tmp";
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex);
        }
        return ".docx";
    }

    private String parseUploadResponse(HttpResponse response, Long fileId) {
        if (!response.isOk()) {
            this.logger.error("\u6587\u4ef6\u4e0a\u4f20RPA HTTP\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u6587\u4ef6ID: {}", (Object)response.getStatus(), (Object)fileId);
            return null;
        }
        String responseBody = response.body();
        this.logger.debug("RPA\u6587\u4ef6\u4e0a\u4f20\u54cd\u5e94: {}", (Object)responseBody);
        try {
            JSONObject jsonResponse = JSONUtil.parseObj((String)responseBody);
            if (RPA_SUCCESS_CODE.equals(jsonResponse.getStr((Object)"code"))) {
                String rpaFileId = jsonResponse.getStr((Object)"data");
                if (StringUtils.isNotBlank((String)rpaFileId)) {
                    this.logger.info("\u6587\u4ef6\u4e0a\u4f20RPA\u6210\u529f\uff0c\u6587\u4ef6ID: {}, RPA\u6587\u4ef6ID: {}", (Object)fileId, (Object)rpaFileId);
                    return rpaFileId;
                }
                this.logger.error("RPA\u54cd\u5e94\u4e2d\u6587\u4ef6ID\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: {}", (Object)fileId);
            } else {
                this.logger.error("\u6587\u4ef6\u4e0a\u4f20RPA\u5931\u8d25\uff0c\u9519\u8bef\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}, \u6587\u4ef6ID: {}", new Object[]{jsonResponse.getStr((Object)"code"), jsonResponse.getStr((Object)"message"), fileId});
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790RPA\u4e0a\u4f20\u54cd\u5e94\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6ID: {}", (Object)fileId, (Object)e);
        }
        return null;
    }

    private void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.logger.warn("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void deleteQuietly(File file) {
        if (file != null && file.exists()) {
            try {
                if (file.delete()) {
                    this.logger.debug("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u6210\u529f: {}", (Object)file.getAbsolutePath());
                } else {
                    this.logger.warn("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25: {}", (Object)file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.logger.warn("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
    }
}

