/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.entity.TemplateEntity;
import com.ejianc.entity.UpLoad;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.service.ITemplateService;
import com.ejianc.service.IUploadFileService;
import com.ejianc.util.FileUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/upload"})
public class UploadFileController {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileController.class);
    @Autowired
    private IUploadFileService uploadFileService;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @PostMapping(value={"/uploadFile"})
    public CommonResponse<List<AttachmentVO>> uploadFile(@RequestBody UpLoad upload) {
        logger.info("\u63a5\u6536\u5230\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", (Object)upload.getBillType(), (Object)upload.getSourceId());
        CommonResponse<List<AttachmentVO>> validationResult = this.validateUploadFileParams(upload);
        if (!validationResult.isSuccess()) {
            return validationResult;
        }
        return this.uploadFileService.uploadFile(upload);
    }

    @PostMapping(value={"/uploadTemplate"})
    @ResponseBody
    public CommonResponse<Void> uploadFileTemplate(@RequestBody UpLoad upload) throws IOException {
        logger.info("\u63a5\u6536\u5230\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\uff0c\u6587\u4ef6ID: {}, \u6a21\u677f\u540d\u79f0: {}", (Object)upload.getFileId(), (Object)upload.getTemplateName());
        CommonResponse<Void> validationResult = this.validateTemplateParams(upload);
        if (!validationResult.isSuccess()) {
            return validationResult;
        }
        String fileName = this.getFileName(upload.getFileId());
        CommonResponse<Void> duplicateCheckResult = this.checkFileNameDuplicate(fileName);
        if (!duplicateCheckResult.isSuccess()) {
            return duplicateCheckResult;
        }
        upload.setFileName(fileName);
        this.uploadFileService.uploadTemplate(upload);
        return CommonResponse.success((String)"\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
    }

    @PostMapping(value={"/deleteTemplate"})
    @ResponseBody
    public CommonResponse<Void> deleteTemplate(@RequestBody UpLoad upload) throws IOException {
        logger.info("\u63a5\u6536\u5230\u6a21\u677f\u5220\u9664\u8bf7\u6c42\uff0c\u6587\u4ef6ID: {}, \u6a21\u677f\u540d\u79f0: {}", (Object)upload.getFileId(), (Object)upload.getFileName());
        CommonResponse<Void> validationResult = this.validateDeleteTemplateParams(upload);
        if (!validationResult.isSuccess()) {
            return validationResult;
        }
        this.uploadFileService.deleteTemplate(upload);
        return CommonResponse.success((String)"\u6a21\u677f\u6587\u4ef6\u5220\u9664\u6210\u529f");
    }

    private CommonResponse<List<AttachmentVO>> validateUploadFileParams(UpLoad upload) {
        if (upload == null) {
            logger.error("\u4e0a\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)upload.getBase64String())) {
            logger.error("base64\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            return CommonResponse.error((String)"base64\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)upload.getBillType()) || StringUtils.isBlank((CharSequence)upload.getSourceId()) || StringUtils.isBlank((CharSequence)upload.getSourceType())) {
            logger.error("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931: billType={}, sourceId={}, sourceType={}", new Object[]{upload.getBillType(), upload.getSourceId(), upload.getSourceType()});
            return CommonResponse.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931: \u5355\u636e\u7c7b\u578b\u3001\u6765\u6e90ID\u3001\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FileUtils.isValidBase64(upload.getBase64String())) {
            logger.error("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32");
            return CommonResponse.error((String)"\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32\u683c\u5f0f");
        }
        logger.info("\u6587\u4ef6\u4e0a\u4f20\u53c2\u6570\u6821\u9a8c\u901a\u8fc7");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u901a\u8fc7", null);
    }

    private CommonResponse<Void> validateTemplateParams(UpLoad upload) {
        if (upload == null) {
            logger.warn("\u6a21\u677f\u4e0a\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u6a21\u677f\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)upload.getFileId())) {
            logger.warn("\u6a21\u677f\u6587\u4ef6ID\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u6a21\u677f\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Long.valueOf(upload.getFileId());
        }
        catch (NumberFormatException e) {
            logger.warn("\u65e0\u6548\u7684\u6a21\u677f\u6587\u4ef6ID\u683c\u5f0f: {}", (Object)upload.getFileId());
            return CommonResponse.error((String)"\u65e0\u6548\u7684\u6a21\u677f\u6587\u4ef6ID\u683c\u5f0f");
        }
        if (StringUtils.isBlank((CharSequence)upload.getTemplateName())) {
            logger.warn("\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)upload.getCategoryName())) {
            logger.warn("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (upload.getBelongOrgName() == null || upload.getBelongOrgName().isEmpty()) {
            logger.warn("\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u6a21\u677f\u4e0a\u4f20\u53c2\u6570\u6821\u9a8c\u901a\u8fc7");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u901a\u8fc7");
    }

    private CommonResponse<Void> validateDeleteTemplateParams(UpLoad upload) {
        if (upload == null) {
            logger.warn("\u6a21\u677f\u5220\u9664\u53c2\u6570\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u6a21\u677f\u5220\u9664\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)upload.getFileId())) {
            logger.warn("\u5220\u9664\u6a21\u677f\u6587\u4ef6ID\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u5220\u9664\u6a21\u677f\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Long.valueOf(upload.getFileId());
        }
        catch (NumberFormatException e) {
            logger.warn("\u65e0\u6548\u7684\u5220\u9664\u6a21\u677f\u6587\u4ef6ID\u683c\u5f0f: {}", (Object)upload.getFileId());
            return CommonResponse.error((String)"\u65e0\u6548\u7684\u5220\u9664\u6a21\u677f\u6587\u4ef6ID\u683c\u5f0f");
        }
        if (StringUtils.isBlank((CharSequence)upload.getFileName())) {
            logger.warn("\u5220\u9664\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a");
            return CommonResponse.error((String)"\u5220\u9664\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u6a21\u677f\u5220\u9664\u53c2\u6570\u6821\u9a8c\u901a\u8fc7");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u901a\u8fc7");
    }

    private String getFileName(String fileId) throws IOException {
        CommonResponse attachmentResponse = this.attachmentApi.queryDetail(fileId);
        if (!attachmentResponse.isSuccess() || attachmentResponse.getData() == null) {
            throw new IOException("\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\uff0c\u6587\u4ef6ID: " + fileId);
        }
        String fileName = ((AttachmentVO)attachmentResponse.getData()).getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: " + fileId);
        }
        return fileName;
    }

    private CommonResponse<Void> checkFileNameDuplicate(String fileName) {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TemplateEntity::getFileName, (Object)fileName);
            List templateEntities = this.templateService.list((Wrapper)queryWrapper);
            if (templateEntities != null && !templateEntities.isEmpty()) {
                logger.warn("\u53d1\u73b0\u91cd\u590d\u7684\u6587\u4ef6\u540d: {}, \u5df2\u5b58\u5728\u7684\u6a21\u677f\u6570\u91cf: {}", (Object)fileName, (Object)templateEntities.size());
                StringBuilder duplicateInfo = new StringBuilder();
                duplicateInfo.append("\u6587\u4ef6\u540d '").append(fileName).append("' \u5df2\u5b58\u5728\uff0c\u91cd\u590d\u7684\u6a21\u677f\u4fe1\u606f\uff1a\n");
                return CommonResponse.error((String)("\u6587\u4ef6\u91cd\u590d: " + duplicateInfo.toString()));
            }
            return CommonResponse.success((String)"\u6587\u4ef6\u540d\u68c0\u67e5\u901a\u8fc7");
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u6587\u4ef6\u540d\u91cd\u590d\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6\u540d: {}", (Object)fileName, (Object)e);
            return CommonResponse.error((String)("\u68c0\u67e5\u6587\u4ef6\u540d\u91cd\u590d\u5931\u8d25: " + e.getMessage()));
        }
    }
}

