package com.ejianc.foundation.front.business.ide.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;

import java.io.Serializable;
import java.util.Date;

/**
 * Module类对应前端设计器的『页面』
 */
public class IdeModuleBo implements Serializable {

	private static final long serialVersionUID = 8281707885929842546L;
	private String id;
	private String appId;
	private String groupId;
	private String name;
	private Date createDate;
	private Date modifyDate;
	private String modifyId;
	private String createId;
	private String code;
	private String appName;
	private String appCode;
	private String teamName;
	private String teamCode;
	private String data;
	private String pageType;
	private String billTypeCode;
	private String clientType;

	public IdeModuleBo() {
	}

	public IdeModuleBo(IdeModule module) {
		if (module == null)
			return;
		this.id = module.getId() + "";
		this.name = module.getName();
		this.code = module.getCode();
		this.data = module.getData();
		this.appId = module.getAppId() + "";
		this.appCode = module.getAppCode();
		this.appName = module.getAppName();
		this.groupId = module.getGroupId() + "";
		this.pageType = module.getPageType();
		this.createDate = module.getCreateDate();
		this.createId = module.getCreateId() + "";
		this.modifyDate = module.getModifyDate();
		this.modifyId = module.getModifyId() + "";
		this.clientType = module.getClientType() + "";
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppCode() {
		return appCode;
	}

	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

	public String getId() {
		return id;

	}

	public void setId(String id) {
		this.id = id;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getCreateDate() {
		return createDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Date getModifyDate() {
		return modifyDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public void setModifyDate(Date modifyDate) {
		this.modifyDate = modifyDate;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public String getTeamCode() {
		return teamCode;
	}

	public void setTeamCode(String teamCode) {
		this.teamCode = teamCode;
	}

	public String getCreateId() {
		return createId;
	}

	public void setCreateId(String createId) {
		this.createId = createId;
	}

	public String getModifyId() {
		return modifyId;
	}

	public void setModifyId(String modifyId) {
		this.modifyId = modifyId;
	}

	public String getData() {
		return data;
	}

	public void setData(String data) {
		this.data = data;
	}

	public String getPageType() {
		return pageType;
	}

	public void setPageType(String pageType) {
		this.pageType = pageType;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public void setBillTypeCode(String billTypeCode) {
		this.billTypeCode = billTypeCode;
	}

	public String getClientType() {
		return clientType;
	}

	public void setClientType(String clientType) {
		this.clientType = clientType;
	}

}
