package com.ejianc.foundation.front.business.ide.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.service.IdeTeamDatasourceService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * 团队数据源controller
 */
@ResponseBody
@RequestMapping("/ide/teamConfig")
@Controller
public class IdeTeamDatasourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamDatasourceController.class);
    @Autowired
    private IdeTeamDatasourceService datasourceService;

    /**
     * 更改团队数据源
     *
     * @param teamId 团队id
     * @param datasourceCodes 数据源编码数组
     * @return  {@link JsonBackData}
     */
    @RequestMapping(value = "/updateTeamDatasource/{teamId}", method = RequestMethod.POST)
    public JsonBackData updateTeamDatasource(@PathVariable String teamId, String[] datasourceCodes) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(datasourceService.updateTeamDatasource(teamId, datasourceCodes));
            backData.setSuccess(true);
            backData.setBackMsg("更改团队数据源成功");
        } catch (Exception e) {
            LOGGER.error("更改团队数据源失败", e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    /**
     * 删除团队数据源
     *
     * @param ids 主键数团队数据源
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{ids}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable("ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            datasourceService.deleteByIds(ids);
            backData.setBackMsg("删除团队数据源成功");
        }  catch (Exception e) {
            LOGGER.error("删除团队数据源失败", e);
            backData.setBackMsg("删除团队数据源错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    /**
     * 获取团队数据源
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public JsonBackData get(@PathVariable("id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(datasourceService.findById(id));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            LOGGER.error("查找团队数据源失败", e);
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value = "findByTeamId/{teamId}", method = RequestMethod.GET)
    public JsonBackData findByTeamId(@PathVariable String teamId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(datasourceService.findByTeamId(teamId));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }
}
