package com.ejianc.foundation.front.business.ide.controller;

import javax.validation.Valid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeUiFolderBO;
import com.ejianc.foundation.front.business.ide.service.IdeUiFolderService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * @author andy
 */
@RequestMapping(value = "ide/uiFolder")
@RestController
public class IdeUiFolderController {
    private static final Logger logger = LoggerFactory.getLogger(IdeUiFolderController.class);

    @Autowired
    private IdeUiFolderService service;

    @RequestMapping(value = "create", method = RequestMethod.POST)
    public JsonBackData create(@Valid @RequestBody IdeUiFolderBO library) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(service.create(library));
        } catch (Exception e) {
            logger.error("创建文件夹异常！", e);
            back.setSuccess(false);
            back.setBackMsg("创建文件夹异常！");
        }
        return back;
    }

    @RequestMapping(value = "update", method = RequestMethod.POST)
    public JsonBackData update(@Valid @RequestBody IdeUiFolderBO library) {
        JsonBackData back = new JsonBackData();
        try {
            service.update(library);
        } catch (Exception e) {
            logger.error("修改文件夹异常！", e);
            back.setSuccess(false);
            back.setBackMsg("修改文件夹异常！");
        }
        return back;
    }

    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public JsonBackData delete(@RequestParam String id) {
        JsonBackData back = new JsonBackData();
        try {
            service.delete(id);
        } catch (Exception e) {
            logger.error("删除文件夹异常！", e);
            back.setSuccess(false);
            back.setBackMsg("删除文件夹异常！");
        }
        return back;
    }

    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    public JsonBackData queryDetail(@RequestParam String id, String searchText) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(service.queryDetail(id, searchText));
        } catch (Exception e) {
            logger.error("查询文件夹详情异常！", e);
            back.setSuccess(false);
            back.setBackMsg("查询文件夹详情异常！");
        }
        return back;
    }
}
