package com.ejianc.foundation.front.business.ide.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CORSFilter implements Filter {
	public static Logger logger = LoggerFactory.getLogger(CORSFilter.class);
    
	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}
	@Override
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {
		HttpServletResponse response = (HttpServletResponse) res;
		HttpServletRequest request = (HttpServletRequest) req;
//		 String origin = request.getHeader("origin");
//        if (origin == null || "".equals(origin)) {
//            origin = "*";
//        } 
//
//        logger.debug("origin---->" + origin);

        response.setHeader("Access-Control-Allow-Origin", "*");   // 没部署nginx,线上环境不好使，暂时注释掉
		response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
		response.setHeader("Access-Control-Max-Age", "3600");
		//ajax通过header传递到后端
		response.setHeader("Access-Control-Allow-Headers", "x-requested-with,Authorization,authority,content-type,ejc-token,Content-Disposition");
		response.setHeader("Access-Control-Allow-Credentials", "true");
		response.setHeader("Access-Control-Expose-Headers", "ejc-content-type,Authorization");
		if(request.getHeader("Access-Control-Request-Headers") != null){
			response.setStatus(200);
		}else{
			chain.doFilter(req, res);
		}
	}
	@Override
	public void destroy() {
	}

}
