package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;

@Mapper
public interface IdeModuleProRepo {
	
	IdeModulePro findById(@Param("id") String id);
	
    List<IdeModulePro> findByCode(@Param("code") String code);
    
	List<IdeModulePro> findByIds(@Param("ids") String ids);
    
	List<IdeApp> findByCodes(@Param("codes") String codes);
    
    void deleteByCode(@Param("code") String code,@Param("toName") String toName);

    List<IdeModulePro> findByAppCodeAndModuleCode(@Param("appCode") String appCode, @Param("pageCode") String pageCode);

    /** 查找该应用下已发布的不同环境下的最新版本页面信息*/
    List<IdeModulePro> findAllLastPublishByAppId(@Param("appId") String appId);

    /** 查询所有发布的页面的最新版*/
	List<IdeModulePro> findAllLastPublish();

    /** 查询所有发布的页面的最新版 根据code筛选*/
	List<IdeModulePro> findAllLastPublishByCodes(@Param("codes") String codes, @Param("toName") String toName);

    /** 查询当前目标环境下的最新版本号*/
    int findMaxVersion(@Param("code") String code, @Param("toName") String toName);

	void update(IdeModulePro module);
}
