package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Service
@Transactional
public class IdeAppGroupServiceImpl implements IdeAppGroupService{
	@Autowired
	IdeAppGroupRepo ideAppGroupRepo;
	@Autowired
	IdeAppRepo ideAppRepo;
	@Autowired
	IdeCommonService ideCommonService;
	
	
	@Override
	public IdeAppGroup save(IdeAppGroup appGroup) throws BusinessException{
		IdeAppGroup ideAppGroup = ideAppGroupRepo.findByTeamIdAndName(String.valueOf(appGroup.getTeamId()), appGroup.getName(), appGroup.getClientType());
		 if (StringUtils.isEmpty(appGroup.getId())) {//创建组
			 if(ideAppGroup != null){
				 throw new BusinessException("同一个团队下不能有相同的应用模块名！");
			 }
			 appGroup.setId(IdWorker.getId());
			 String appGroupCode = ideCommonService.generateAppGroupCode();
			 appGroup.setCode(appGroupCode);
			 appGroup.setCreateDate(new Date());
			 ideAppGroupRepo.save(appGroup);
	        } else {//修改组
	        	if(ideAppGroup != null&&!ideAppGroup.getName().equals(appGroup.getName())){
					 throw new BusinessException("同一个团队下不能有相同的应用模块名！");
				 }
	        	IdeAppGroup _appGroup = ideAppGroupRepo.findOne(String.valueOf(appGroup.getId()));
	        	_appGroup.setName(appGroup.getName());
	        	_appGroup.setModifyDate(new Date());
	        	appGroup = ideAppGroupRepo.update(_appGroup);
	        }

	     return appGroup;
	}

	@Override
	public void deleteByIds(String[] ids) throws BusinessException{
		String idStr = "";
		if(ids != null && ids.length > 0) {
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length() - 1);
			List<IdeAppGroup> list = ideAppGroupRepo.findHasAppByIds(idStr);
			if(list != null&&list.size()>0){
				Map<String,String> groupNames = new HashMap<>();
				for (IdeAppGroup ideAppGroup : list) {
					groupNames.put(String.valueOf(ideAppGroup.getId()),ideAppGroup.getName());
				}
				if(groupNames.size()>0){
					throw new BusinessException(groupNames.values().toString()+"模块下存在应用，不可删除！");
				}
			}
			ideAppGroupRepo.logicDel(idStr);
		}
	}

	@Override
	public IdeAppGroup findById(String id) throws BusinessException{
		return ideAppGroupRepo.findOne(id);
	}

	@Override
	public List<IdeAppGroup> findByTeamId(String teamId,String clientType) {
		List<IdeAppGroup> appGroups = ideAppGroupRepo.findByTeamId(teamId,clientType);
		if(appGroups != null && appGroups.size()>0){
			for (IdeAppGroup ideAppGroup : appGroups) {
				ideAppGroup.setApps(ideAppRepo.findAppByGroupId(String.valueOf(ideAppGroup.getId())));
			}
		}
		return appGroups;
	}

	@Override
	public List<IdeAppGroup> findByTeamIds(String teamIds, String clientType){
		//获取团队下的所有模块
		String teamIdStr = teamIds;
		List<IdeAppGroup> appGroups = ideAppGroupRepo.findByTeamIds(teamIdStr, clientType);
		if(appGroups != null && appGroups.size()>0){
			String groupIds = "";
	    	for(int i=0;i<appGroups.size();i++){
	    		groupIds += appGroups.get(i).getId() + ",";
	    	}
	    	//获取所有模块下的相关应用
	    	List<IdeApp> ideApps = ideAppRepo.findAppByGroupIds(groupIds.substring(0, groupIds.length()-1));
	    	if(ideApps != null && ideApps.size() > 0){
	        	Map<String,List<IdeApp>> appMap = new HashMap<String,List<IdeApp>>();
	        	for (IdeApp app : ideApps) {
	        		List<IdeApp> appList = appMap.get(app.getGroupId());
	        		if(appList==null){
	        			appList = new ArrayList<IdeApp>();
	        		}
	        		appList.add(app);
	        		appMap.put(String.valueOf(app.getGroupId()), appList);
	        	}
	        	for (IdeAppGroup appGroup : appGroups) {
					appGroup.setApps(appMap.get(appGroup.getId()));
				}
	    	}	
		}
		return appGroups;
	}

}
