package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentBO;
import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentWhiteListBO;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironment;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironmentWhiteList;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeEnvironmentRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEnvironmentWhiteListRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Service 
@Transactional
public class IdeEnvironmentServiceImpl implements IdeEnvironmentService{
	
	@Autowired
	private IdeEnvironmentRepo ideEnvironmentRepo;
	@Autowired
	private IdeEnvironmentWhiteListRepo ideEnvironmentWhiteListRepo;
	@Autowired
	private IdeTeamRepo ideTeamRepo;

	@Override
	public Page<IdeEnvironmentBO> findAll(Pageable pageable) throws BusinessException, Exception {
		Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
		Integer pageSize = pageable.getPageSize();
		
		List<IdeEnvironment> contents = ideEnvironmentRepo.findList(pageIndex, pageSize);
		Long total = ideEnvironmentRepo.findCount();
		if (contents != null && contents.size() > 0) {
			List<IdeEnvironmentBO> list = new ArrayList<>();
			Map<String, List<IdeEnvironmentWhiteList>> map = new HashMap<>();
			List<IdeEnvironmentWhiteList> lists = null;
			IdeEnvironmentBO bo = null;
			String urlStr = "";
			for (IdeEnvironment ideEnvironment : contents) {
				bo = new IdeEnvironmentBO();
				urlStr += ideEnvironment.getUrl() + ",";
				bo.setId(String.valueOf(ideEnvironment.getId()));
				bo.setName(ideEnvironment.getName());
				bo.setUrl(ideEnvironment.getUrl());
				bo.setEnableWhiteList(ideEnvironment.getEnableWhiteList());
				list.add(bo);
			}
			List<IdeEnvironmentWhiteList> whiteLists = ideEnvironmentWhiteListRepo.findByUrls(urlStr.substring(0, urlStr.length()-1));
			if (whiteLists.size() > 0 && whiteLists !=null) {
				for (IdeEnvironmentWhiteList whiteList : whiteLists) {
					if (map.containsKey(whiteList.getUrl())) {
						map.get(whiteList.getUrl()).add(whiteList);
					}else {
						lists = new ArrayList<>();
						lists.add(whiteList);
						map.put(whiteList.getUrl(), lists);
					}
				}
			}
			for (IdeEnvironmentBO ideEnvironmentBO : list) {
				List<IdeEnvironmentWhiteList> environmentWhiteLists = map.get(ideEnvironmentBO.getUrl());
				if(environmentWhiteLists != null){
					ideEnvironmentBO.setWhiteListNum(environmentWhiteLists.size());
				}else {
					ideEnvironmentBO.setWhiteListNum(0);
				}
			}
			return new PageImpl<>(list, pageable, total);
		}	
		return null;
	}

	@Override
	public void saveOrUpdate(IdeEnvironmentBO bo) throws BusinessException, Exception {
		IdeEnvironment environment = new IdeEnvironment();
		if (StringUtils.isEmpty(bo.getId())) {
			IdeEnvironment ideEnvironment = ideEnvironmentRepo.findByUrl(bo.getUrl());
			if (ideEnvironment != null) {
				throw new BusinessException("该url已存在！");
			}else {
				environment.setId(IdWorker.getId());
				environment.setEnableWhiteList(bo.getEnableWhiteList());
				environment.setName(bo.getName());
				environment.setUrl(bo.getUrl());
				ideEnvironmentRepo.save(environment);
				List<IdeEnvironmentWhiteListBO> listBOs = bo.getWhiteListBOs();
				if (listBOs != null && listBOs.size()>0) {
					for (IdeEnvironmentWhiteListBO bo2 : listBOs) {
						IdeEnvironmentWhiteList whiteList = new IdeEnvironmentWhiteList();
						whiteList.setId(IdWorker.getId());
						whiteList.setTeamId(bo2.getTeamId());
						whiteList.setUrl(bo.getUrl());
						ideEnvironmentWhiteListRepo.save(whiteList);
						
					}
				}
			}
		}else {
			ideEnvironmentWhiteListRepo.deleteByUrls(bo.getUrl());
			environment.setId(Long.parseLong(bo.getId()));
			environment.setEnableWhiteList(bo.getEnableWhiteList());
			environment.setName(bo.getName());
			environment.setUrl(bo.getUrl());
			ideEnvironmentRepo.update(environment);
			List<IdeEnvironmentWhiteListBO> listBOs = bo.getWhiteListBOs();
			if (listBOs != null && listBOs.size()>0) {
				for (IdeEnvironmentWhiteListBO bo2 : listBOs) {
					IdeEnvironmentWhiteList whiteList = new IdeEnvironmentWhiteList();
					whiteList.setId(IdWorker.getId());
					whiteList.setTeamId(bo2.getTeamId());
					whiteList.setUrl(bo.getUrl());
					ideEnvironmentWhiteListRepo.save(whiteList);
				}
			}
		}
	}

	@Override
	public void deleteByUrls(String[] urls) throws BusinessException, Exception {
		String urlStr = "";
		if(urls != null && urls.length > 0) {
			for(String url:urls) {
				urlStr += url + ",";
			}
			urlStr = urlStr.substring(0, urlStr.length()-1);
			ideEnvironmentRepo.deleteByUrls(urlStr);
			ideEnvironmentWhiteListRepo.deleteByUrls(urlStr);
		}
	}

	@Override
	public IdeEnvironmentBO findByUrl(String url, int proType) throws BusinessException, Exception {
		IdeEnvironment ideEnvironment = ideEnvironmentRepo.findByUrl(url);
		List<IdeTeam> allTeams = ideTeamRepo.findTeamByProdType(proType);
		IdeEnvironmentBO bo = new IdeEnvironmentBO();
		Map<String, IdeTeam> map = new HashMap<>();
		for (IdeTeam ideTeam : allTeams) {
			map.put(String.valueOf(ideTeam.getId()), ideTeam);
		}
		List<IdeEnvironmentWhiteList> whiteLists = ideEnvironmentWhiteListRepo.findByUrls(url);
		if (ideEnvironment != null) {
			List<IdeEnvironmentWhiteListBO> whiteListbos = new ArrayList<>();
			IdeEnvironmentWhiteListBO whiteListBO = null;
			bo.setId(String.valueOf(ideEnvironment.getId()));
			bo.setName(ideEnvironment.getName());
			bo.setUrl(ideEnvironment.getUrl());
			bo.setEnableWhiteList(ideEnvironment.getEnableWhiteList());
			bo.setWhiteListNum(whiteLists.size());
			if (whiteLists != null && whiteLists.size()>0) {
				for (IdeEnvironmentWhiteList whiteList : whiteLists) {
					whiteListBO = new IdeEnvironmentWhiteListBO();
					whiteListBO.setId(String.valueOf(whiteList.getId()));
					whiteListBO.setTeamId(whiteList.getTeamId());
					whiteListBO.setUrl(whiteListBO.getUrl());
					IdeTeam ideTeam = map.get(whiteList.getTeamId());
					if (ideTeam != null) {
						whiteListBO.setTeamCode(ideTeam.getCode());
						whiteListBO.setTeamName(ideTeam.getName());
						map.remove(whiteList.getTeamId());
					}
					whiteListbos.add(whiteListBO);
				}
				bo.setWhiteListBOs(whiteListbos);
			}			
		}
		List<IdeTeam> leftTeam = new ArrayList<IdeTeam>(map.values());  
		bo.setLeftTeams(leftTeam);
		return bo;

	}

	@Override
	public boolean isInWhiteList(String url, String teamId) {
		IdeEnvironment ideEnvironment = ideEnvironmentRepo.findByUrl(url);
		if (ideEnvironment != null ) {
			if (ideEnvironment.getEnableWhiteList() == 1) {
				IdeEnvironmentWhiteList ideEnvironmentWhiteList = ideEnvironmentWhiteListRepo.findByUrlAndTeam(url, teamId);
				if (ideEnvironmentWhiteList == null) {
					return false;
				}
			}
		}
		return true;

	}

	@Override
	public List<IdeEnvironment> findAllUrls() {
		return ideEnvironmentRepo.findAllUrls();
	}

	@Override
	public IdeEnvironment findById(String id) {
		return ideEnvironmentRepo.findOne(id);
	}

	
}
