package com.ejianc.foundation.front.business.ide.service.impl;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivateVerifyHis;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateVerifyHisRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;

@Service
@Transactional
public class IdeModulePrivateServiceImpl implements IdeModulePrivateService{
	
	@Autowired
	private IdeModulePrivateRepo ideModulePrivateRepo;
	@Autowired
	private IdeModuleRepo ideModuleRepo;
	@Autowired
	private IdeTeamRepo ideTeamRepo;
	@Autowired
	private IdeAppRepo ideAppRepo;
	@Autowired
	private IdeModulePrivateVerifyHisRepo ideModulePrivateVerifyHisRepo;
	@Autowired
	private IOrgApi orgApi;
	
	@Override
	public Page<IdeModulePrivate> findByCode(String code, String orgId, String appId, String tenantId, Pageable pageable) throws BusinessException, Exception {
		if (!StringUtils.isEmpty(orgId)) {
			Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
			Integer pageSize = pageable.getPageSize();
			String orgIdStrs = "";
			List<String> orgIds = this.findChildOrgIds(orgId);
			for(String orgIdStr:orgIds) {
				orgIdStrs += orgIdStr + ",";
			}
			orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length()-1);
			List<IdeModulePrivate> ideModulePrivageList = ideModulePrivateRepo.queryModulePrivateList(orgIdStrs, code, appId, pageIndex, pageSize);
			Long ideModulePrivageCount = ideModulePrivateRepo.queryModulePrivateCount(orgIdStrs, code, appId);
			return new PageImpl<>(ideModulePrivageList, pageable, ideModulePrivageCount);
		}else {
			return new PageImpl<>(new ArrayList<>(), pageable, 0);
		}
	}

	@Override
	public void saveOrUpdate(IdeModulePrivate ideModulePrivate) throws BusinessException {
		if (ideModulePrivate.getId() == null || ideModulePrivate.getId() == 0) {
			List<IdeModulePrivate> modulePrivate = ideModulePrivateRepo.findByCodeAndOrgId(ideModulePrivate.getCode(), String.valueOf(ideModulePrivate.getOrgId()));
			if (modulePrivate != null && modulePrivate.size()>0) {
				throw new BusinessException("当前组织已存在配置页面！");
			}else {
				IdeModule ideModule = ideModuleRepo.findByAppCodeAndModuleCode(ideModulePrivate.getAppCode(), ideModulePrivate.getCode());
				ideModulePrivate.setId(IdWorker.getId());
				ideModulePrivate.setAppId(ideModule.getAppId());
				ideModulePrivate.setCreateDate(new Date());
				ideModulePrivate.setCreateId(ideModule.getCreateId());
				ideModulePrivate.setData(ideModule.getData());
				ideModulePrivate.setName(ideModule.getName());
				ideModulePrivate.setPageType(ideModule.getPageType());
				ideModulePrivate.setAppCode(ideModule.getAppCode());
				ideModulePrivateRepo.save(ideModulePrivate);
			}
		}else {
			IdeModulePrivate newModulePrivate = ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
			newModulePrivate.setModifyDate(new Date());
			if (ideModulePrivate.getIsCompatible() == 1) {
				newModulePrivate.setIsCompatible(0);
			}else {
				newModulePrivate.setIsCompatible(1);
			}
			ideModulePrivateRepo.update(newModulePrivate);
		}
	}

	@Override
	public void changeIsDevelopment(IdeModulePrivate ideModulePrivate) throws BusinessException {
		IdeModulePrivate newModulePrivate = ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
		newModulePrivate.setModifyDate(new Date());
		newModulePrivate.setIsDevelopment(ideModulePrivate.getIsCompatible());
		ideModulePrivateRepo.update(newModulePrivate);
	}

	@Override
	public void deleteByIds(List<String> ids) throws BusinessException, Exception {
		String idStr = "";
		if(ids != null && ids.size() > 0) {
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			ideModulePrivateRepo.deleteByIds(idStr);
		}
	}

	@Override
	public IdeModulePrivate findByOrgId(String pageCode, String appCode, String orgId, String tenantId){
		IdeModulePrivate ideModulePrivate = ideModulePrivateRepo.findByOrgId(appCode, pageCode, orgId);
		if (ideModulePrivate != null) {
			return ideModulePrivate;
		}else {
			CommonResponse<List<OrgVO>> response = orgApi.findParentsByOrgId(Long.parseLong(orgId));
			if(response.isSuccess()) {
				String orgIds = "";
				List<OrgVO> orgVos = response.getData();
				if(orgVos != null && orgVos.size() > 0) {
					for(OrgVO orgVo:orgVos) {
						orgIds += orgVo.getId() + ",";
					}
					orgIds = orgIds.substring(0, orgIds.length()-1);
				}
				if(!com.ejianc.foundation.front.util.StringUtils.isEmpty(orgIds)){
					List<IdeModulePrivate> list = ideModulePrivateRepo.findByOrgIds(appCode, pageCode, orgIds);
					if(list != null && list.size() > 0) {
						return list.get(0);
					}
				}
			}
		}
		return null;
	}

	@Override
	public IdeModulePrivate findByOrgIdAndCode(String pageCode, String appCode, String orgId) throws BusinessException {
		IdeModulePrivate ideModulePrivate = ideModulePrivateRepo.findByOrgId(appCode, pageCode, orgId);
		if (ideModulePrivate != null) {
			return ideModulePrivate;
		}else {
			throw new BusinessException("该组织不存在该页面的实例");
		}
	}

	@Override
	public void saveData(IdeModulePrivate ideModulePrivate) throws BusinessException {
		IdeModulePrivate modulePrivate = ideModulePrivateRepo.findByOrgId(ideModulePrivate.getAppCode(), ideModulePrivate.getCode(), String.valueOf(ideModulePrivate.getOrgId()));
		if (modulePrivate != null) {
			modulePrivate.setData(ideModulePrivate.getData());
			ideModulePrivateRepo.save(modulePrivate);
		}else {
			throw new BusinessException("该组织不存在该页面的实例");
		}
	}

	@Override
	public void updateData(IdeModulePrivate ideModulePrivate) throws BusinessException {
		if (ideModulePrivate != null) {
			ideModulePrivateRepo.update(ideModulePrivate);
		} else {
			throw new BusinessException("该组织不存在该页面的实例");
		}

	}
	
	//通过rest服务根据组织id获取本下级组织
	private List<String> findChildOrgIds(String orgId) throws BusinessException, Exception {
		List<String> orgIds = new ArrayList<>();
		CommonResponse<List<OrgVO>> response = orgApi.findChildrenByParentId(Long.parseLong(orgId));
		if(response.isSuccess()) {
			List<OrgVO> orgVos = response.getData();
			if(orgVos != null && orgVos.size() > 0) {
				for(OrgVO orgVo : orgVos) {
					orgIds.add(orgVo.getId().toString());
				}
			}
		}
		return orgIds;
	}


	@Override
	public List<String> findNodeIds(String orgId, String tenantId) throws BusinessException, Exception {
		if (StringUtils.isNotBlank(orgId)) {
			List<String> nodeIds = new ArrayList<>();
			List<Object> params = new ArrayList<>();
			List<String> orgIds = this.findChildOrgIds(orgId);
			params.add(orgIds);
			List<IdeTeam> ideTeams = this.findTeamHasData(params);
			if (ideTeams != null && ideTeams.size() >0) {
				for (IdeTeam ideTeam : ideTeams) {
					nodeIds.add(String.valueOf(ideTeam.getId()));
				}
			}
			List<IdeApp> ideApps = this.findAppHasData(params);
			if (ideApps != null && ideApps.size() >0) {
				for (IdeApp ideApp : ideApps) {
					nodeIds.add(String.valueOf(ideApp.getId()));
				}
			}
			List<IdeModule> ideModules = this.findPageHasData(params);
			if (ideModules != null && ideModules.size() >0) {
				for (IdeModule ideModule : ideModules) {
					nodeIds.add(String.valueOf(ideModule.getId()));
				}
			}
		    return nodeIds;
		}else {
			return null;
		}
	}
	
	//根据团队查找是否有实例
	private List<IdeTeam> findTeamHasData(List<Object> params) throws BusinessException, Exception {
		String orgIds = "";
		if(params != null && params.size() > 0) {
			for(Object object:params) {
				orgIds += object.toString() + ",";
			}
			orgIds = orgIds.substring(0, orgIds.length() - 1);
		}
		List<IdeTeam> ideTeams = ideTeamRepo.findTeamHasData(orgIds);
		return ideTeams;
	}
	
	//根据应用查找是否有实例
	private List<IdeApp> findAppHasData(List<Object> params) throws BusinessException, Exception {
		String orgIds = "";
		for(Object param:params) {
			orgIds += param.toString() + ",";
		}
		orgIds = orgIds.substring(0, orgIds.length()-1);
		List<IdeApp> ideAppList = ideAppRepo.queryAppHasData(orgIds);
		return ideAppList;
	}
	
	//根据页面查找是否有实例
	private List<IdeModule> findPageHasData(List<Object> params) throws BusinessException, Exception {
		String orgIds = "";
		for(Object param:params) {
			orgIds += param.toString() + ",";
		}
		orgIds = orgIds.substring(0, orgIds.length()-1);
		List<IdeModule> ideModuleList = ideModuleRepo.queryPageHasData(orgIds);
		return ideModuleList;
	}



	@Override
	public List<IdeModule> findModule(String appId) throws BusinessException {
		List<IdeModule> ideModuleList = ideModuleRepo.findDetailsByAppId(appId);
		return ideModuleList;
	}

	@Override
	public List<IdeModuleBo> searchByModuleCodeAndName(String searchText, int maxCount) throws BusinessException {
		if (StringUtils.isEmpty(searchText)) {
			return new ArrayList<IdeModuleBo>();
		}
		List<IdeModuleBo> ideModuleBoList = ideModuleRepo.queryListByModuleCodeAndName(searchText, maxCount);
		return ideModuleBoList;
	}

	@Override
	public IdeModulePrivate findById(String id) throws Exception {
		IdeModulePrivate ideModulePrivate = ideModulePrivateRepo.findById(id);
		if (ideModulePrivate == null) {
			throw new BusinessException("页面数据不存在或已被删除");
		}
		return ideModulePrivate;
	}

	@Override
	public void updateAttach(IdeModulePrivate ideModulePrivate) throws BusinessException {
		IdeModulePrivate newModulePrivate = ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
		newModulePrivate.setModifyDate(new Date());
		newModulePrivate.setModifyId(ideModulePrivate.getModifyId());
		newModulePrivate.setAttachIdDev(ideModulePrivate.getAttachIdDev());
		newModulePrivate.setAttachPathDev(ideModulePrivate.getAttachPathDev());
		newModulePrivate.setAttachVerify(ideModulePrivate.getAttachVerify());
		ideModulePrivateRepo.update(newModulePrivate);
	}

	@Override
	public Page<IdeModulePrivate> findUnverifyList(String code, String orgId, String appId, String tenantId, Pageable pageable, String condition) throws BusinessException, Exception {
		if (StringUtils.isNotBlank(orgId)) {
			Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
			Integer pageSize = pageable.getPageSize();
			String orgIdStrs = "";
			List<String> orgIds = this.findChildOrgIds(orgId);
			for(String orgIdStr:orgIds) {
				orgIdStrs += orgIdStr + ",";
			}
			orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length()-1);
			List<IdeModulePrivate> ideModulePrivateList = ideModulePrivateRepo.queryUnverifyList(code,orgIdStrs,appId,condition,pageIndex,pageSize);
			Long ideModulePrivateCount = ideModulePrivateRepo.queryUnverifyCount(code,orgIdStrs,appId,condition);
			
			return new PageImpl<>(ideModulePrivateList, pageable, ideModulePrivateCount);
		} else {
			return new PageImpl<>(new ArrayList<>(), pageable, 0);
		}

	}

	@Override
	public void updateAttachVerify(List<String> ids, String modifyId, String modifyName) throws BusinessException {
		if (null == ids || ids.isEmpty()) {
			throw new BusinessException("被审核的数据id为空。");
		} else {
			String idStr = "";
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			ideModulePrivateRepo.updateAttachVerify(modifyId, idStr);
			// 保存审核历史
			List<IdeModulePrivate> ideModulePrivateList = ideModulePrivateRepo.findByIds(idStr);
			for (IdeModulePrivate item : ideModulePrivateList) {
				IdeModulePrivateVerifyHis his = new IdeModulePrivateVerifyHis();
				his.setId(IdWorker.getId());
				his.setPrivateId(String.valueOf(item.getId()));
				his.setAttachId(item.getAttachIdPro());
				his.setAttachPath(item.getAttachPathPro());
				his.setVerifyName(modifyName);
				his.setCreateId(Long.parseLong(modifyId));
				his.setCreateDate(item.getModifyDate());
				ideModulePrivateVerifyHisRepo.save(his);
			}
		}
	}

	@Override
	public Page<IdeModulePrivateVerifyHis> findVerifyHistoryList(String code, String orgId, String appId, 
			String tenantId, Pageable pageable, String condition) throws BusinessException, Exception {
		if (!StringUtils.isEmpty(orgId)) {
			Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
			Integer pageSize = pageable.getPageSize();
			String orgIdStrs = "";
			List<String> orgIds = this.findChildOrgIds(orgId);
			for(String orgIdStr:orgIds) {
				orgIdStrs += orgIdStr + ",";
			}
			orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length()-1);
			List<IdeModulePrivateVerifyHis> modulePrivateVerifyHisList = ideModulePrivateRepo.queryVerifyHistoryList(code,orgIdStrs,appId,condition,pageIndex,pageSize);
			Long modulePrivateVerifyHisCount = ideModulePrivateRepo.queryVerifyHistoryCount(code,orgIdStrs,appId,condition);
			return new PageImpl<>(modulePrivateVerifyHisList, pageable, modulePrivateVerifyHisCount);
		} else {
			return new PageImpl<>(new ArrayList<>(), pageable, 0);
		}
	}

	
}
