package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.*;

import com.ejianc.foundation.front.business.ide.entity.*;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Dio.zhu
 */
@Service
@Transactional
public class IdeModuleServiceImpl implements IdeModuleService {

	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleServiceImpl.class);

    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModuleRepo ideModuleRepoImpl;
    @Autowired
    IdeTeamRepo ideTeamRepo;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModulePrivateService ideModulePrivateService;
    @Autowired
    IdeEnvironmentService ideEnvironmentService;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
	private MetadataReaderService metadataReaderService;
    
    @Override
    public IdeModule saveOrUpdate(IdeModule ideModule) throws Exception {
        IdeModule ideModuleTemp = null;
        if (ideModule.getId() == null) { // 新增
            if (StringUtils.isBlank(String.valueOf(ideModule.getAppId()))) {
                throw new BusinessException("所属应用不能为空");
            }
            if (StringUtils.isBlank(ideModule.getName())) {
                throw new BusinessException("页面名称不能为空");
            }
            List<IdeModule> ideModuleList = ideModuleRepo.findByName(ideModule.getName(), String.valueOf(ideModule.getAppId()));
            if (ideModuleList.size()>0) {
            	throw new BusinessException("已存在的页面名称");
            }
            else {
            	ideModule.setId(IdWorker.getId());
            	String code = ideCommonService.generateModuleCode();
            	ideModule.setCode(code);
            	Date nowDate = new Date();
                ideModule.setCreateDate(nowDate);

                if(ideModule.isReadEntityMetadata()) {
                	JSONObject data = metadataReaderService.readMetadata(ideModule.getBillType(), ideModule.getEntityId().toString(), ideModule.getPageType());
                	ideModule.setData(data == null ? null : data.toJSONString());
				}

                ideModuleRepo.save(ideModule);
                return ideModule;
            }
        } else { //修改
            ideModuleTemp = ideModuleRepo.findById(String.valueOf(ideModule.getId()));
            ideModuleTemp.setTs(new Date().getTime());
            ideModuleTemp.setName(ideModule.getName());
            if(StringUtils.isNotBlank(ideModule.getClientType())) {
            	ideModuleTemp.setClientType(ideModule.getClientType());
            }
            ideModuleTemp.setModifyDate(new Date());
            if(ideModule.getData()!=null){
            	ideModuleTemp.setData(ideModule.getData());
            }
            if(StringUtils.isNotBlank(String.valueOf(ideModule.getGroupId()))){
            	 ideModuleTemp.setGroupId(ideModule.getGroupId());
            }
            ideModuleRepo.update(ideModuleTemp);
            return ideModuleTemp;
        }

    }

    @Override
    public void copyModule(IdeModule ideModule)  throws Exception{
        IdeModule ideModuleSrc = ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        IdeModule ideModuleSave = new IdeModule();
        ideModuleSave.setId(IdWorker.getId());
        BeanUtils.copyProperties(ideModuleSrc, ideModuleSave, new String[]{"id","fromId","fromName","createId","createDate","name"});
        ideModuleSave.setCreateId(ideModule.getCreateId());
        ideModuleSave.setCreateDate(new Date());
        ideModuleSave.setName(ideModule.getName());
        String code = ideCommonService.generateModuleCode();
        ideModuleSave.setCode(code);
        ideModuleSave.setAppId(ideModule.getAppId());
        ideModuleSave.setGroupId(ideModule.getGroupId());
        ideModuleSave.setFromId(ideModule.getFromId());
        ideModuleSave.setPageType(ideModule.getPageType());
        ideModuleSave.setFromName(ideModule.getFromName());
        ideModuleRepo.save(ideModuleSave);
    }

    @Override
    public IdeModule findByCode(String moduleCode) {
        List<IdeModule> ideModules = ideModuleRepo.findAllByCode(moduleCode);
        if(ideModules!=null&&ideModules.size()>0){
			return ideModules.get(0);
		}else{
			return null;
		}
    }
    @Override
    public List<IdeModule> findByAppId(String appId) throws Exception {
        List<IdeModule> ideModules = ideModuleRepo.findDetailsByAppId(appId);
        return ideModules;
    }
    @Override
    public List<IdeModule> findIsDeleteModules(String appId) throws Exception {
    	List<IdeModule> ideModules = ideModuleRepo.findModulesByAppId(appId,1);
    	return ideModules;
    }

    @Override
    public void deleteById(String id) throws Exception {
    	ideModuleRepo.deleteById(id);
    	ideModulePrivateRepo.deleteByModuleIds(id);
		IdeModuleData moduleData = moduleDataRepo.findByModuleId(Long.parseLong(id));
		if (moduleData != null) {
			moduleDataRepo.deleteById(moduleData);
		}
    }

    @Override
    public IdeModuleBo findById(String id) throws Exception {
    	IdeModuleBo ideModuleBo = ideModuleRepoImpl.findDetailById(id);
    	if (ideModuleBo==null){
    		throw new BusinessException("没有可备份的页面");
    	}
        return ideModuleBo;
    }
    
    @Override
    public IdeModule findEntityById(String id) {
        return ideModuleRepo.findById(id);
    }

    @Override
    public IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode)  {
		LOGGER.info("findByAppCodeAndModuleCode ======== {{}}---{{}}",appCode,moduleCode);
        return ideModuleRepo.findByAppCodeAndModuleCode(appCode,moduleCode);
    }
    @Override
	public Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String moduleCode, String orgId,String tenantId) {
    	IdeModulePrivate orgPage = null;
    	//存在组织Id则优先按按组织查找实例化后的页面
		if(orgId!=null&&!"".equals(orgId)&&tenantId!=null&&!"".equals(tenantId)){
			orgPage = ideModulePrivateService.findByOrgId(moduleCode, appCode, orgId,tenantId);
		}
		LOGGER.info("orgPage ======== "+orgPage);
		//存在当前组织的页面实例则直接返回
		if(orgPage !=null){
			return orgPage;
		}else{//否则查询界面设计器的原页面
			return this.findByAppCodeAndModuleCode(appCode, moduleCode);
		}
	}
	@Override
	public void publishHistory(IdeModule ideModule,String fromName,String toName) {
		IdeModulePro module = new IdeModulePro();
		BeanUtils.copyProperties(ideModule, module, new String[]{"id","createDate","modifyDate"});
		module.setCreateDate(new Date());//发布时间
		module.setFromName(fromName);
		module.setToName(toName);
		int maxVer = ideModuleProRepo.findMaxVersion(ideModule.getCode(),toName);
		maxVer = maxVer+1;
		module.setVerNum(maxVer);
		ideModuleProRepo.update(module);
	}
	@Override
	public List<IdeModule> findInAppIds(String[] appIds) {
		List<IdeModule> modules = new ArrayList<>();
		if(appIds==null||appIds.length==0)return modules;
		String appIdStr = "'"+ org.apache.commons.lang.StringUtils.join(Arrays.asList(appIds),"','")+"'";
		modules = ideModuleRepo.findInAppIds(appIdStr);
		return modules;
	}
	/**
	 * 作用在开发环境上，将数据发送给生产环境
	 */
	@Transactional
	@Override
	public JsonBackData syncPublishProduction(String appId, List<String> pageIds, String fromName, String toName)
			throws Exception {
		if (StringUtils.isBlank(toName)) {
			return JsonBackData.toError("无法发布：发布目标地址不存在！");
		}
		if (pageIds == null || pageIds.size() == 0) {
			return JsonBackData.toError("无法发布：没有可发布的页面！");
		}
		// 查询已存在的应用和页面
		IdeApp app = ideAppService.findById(appId);
		if (app == null) {
			return JsonBackData.toError("发布的应用[" + appId + "]不存在，请刷新重试！");
		}
		// 获取应用所属团队信息
		IdeTeamBo team = null;
		// 如果发布的目标地址启用了白名单策略则验证本团队是否在白名单列表，如果不存在白名单中则不允许发布。
		if (app.getTeamId() != null) {
			if (!ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
				return JsonBackData.toError("本团队被限制发布应用到[" + toName + "]环境，可联系超级管理员进行授权！");
			}
			IdeTeam teamBean = ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
			if(teamBean!=null){
				team = new IdeTeamBo(teamBean);
			}
		}
		// 记录不存在的页面
		List<String> notExistPages = new ArrayList<String>();
		// 记录发失败的页面
		List<String> failPages = new ArrayList<String>();
		// 打包需要同步的应用和页面信息
		IdeProductionBo postData = new IdeProductionBo();
		postData.setIdeTeam(team);
		postData.setIdeApp(new IdeAppBo(app));
		postData.setFromName(fromName);
		postData.setToName(toName);
		List<IdeModule> publishModules = new ArrayList<IdeModule>();
		// 遍历同步发布页面
		for (String moduleId : pageIds) {
			IdeModule module = this.findEntityById(moduleId);
			if (module == null) {
				// 记录不存在的页面
				notExistPages.add(moduleId);
				continue;
			}
			publishModules.add(module);
			// 追加存在的可发布的页面
			postData.getIdeModules().add(new IdeModuleBo(module));
		}
		//筛选出没发生改变的页面
		publishModules = ideModuleProService.findDiffLastPublish(publishModules, toName);
		if(publishModules.size()==0) {
			return JsonBackData.toSuccess("所发布页面与最新版本相同，无需重复发布");
		}
		for(IdeModule ideModule: publishModules) {
			// 追加存在的可发布的页面
			postData.getIdeModules().add(new IdeModuleBo(ideModule));
		}
		ObjectMapper mapper = new ObjectMapper();
		String postJson = mapper.writeValueAsString(postData);
		// 数据同步到目标服务器的数据库
		HttpResponse httpresponse = HttpClientUtil.postJSON(toName + Constant.PUBLISH_SYNC_URL, postJson);
		if (httpresponse == null) {
			return JsonBackData.toError("发布失败，目标服务器响应异常");
		}
		// 获取状态码
		int resCode = httpresponse.getStatusLine().getStatusCode();
		// 请求失败
		if (resCode != 200) {
			return JsonBackData.toError("发布失败，目标服务器异常，响应状态码：" + resCode);
		}
		// 请求成功，取到返回内容(JsonBackData对象)
		JSONObject resultObj = null;
		String result = EntityUtils.toString(httpresponse.getEntity());
		try {
			resultObj = (JSONObject) JSONObject.parse(result);
		} catch (Exception e) {
			// 解析不了的返回值直接return
			e.printStackTrace();
			return JsonBackData.toError(result);
		}
		// 返回数据
		JsonBackData jsonBackData = new JsonBackData();
		jsonBackData.setSuccess(resultObj.getBoolean("success"));
		jsonBackData.setBackData(resultObj.get("backData"));
		jsonBackData.setBackMsg(resultObj.getString("backMsg"));
		// 保存阿里云/本地环境
		if (jsonBackData.isSuccess()) {
			// 保存到发布历史记录
			for (IdeModule module : publishModules) {
				this.publishHistory(module, fromName, toName);
			}
			// 记录同步到目标服务器失败的页面
			ObjectMapper objectMapper = new ObjectMapper();
			failPages = objectMapper.readValue(objectMapper.writeValueAsString(jsonBackData.getBackData()),
					new TypeReference<ArrayList<String>>() {
					});
		} else {
			return jsonBackData;
		}
		if (notExistPages.size() > 0 || failPages.size() > 0) {
			Map<String, Object> backData = new HashMap<String, Object>();
			backData.put("notExist", notExistPages.size());
			backData.put("failPages", failPages);
			return JsonBackData.toSuccess("发布完成", backData);
		} else {
			return JsonBackData.toSuccess("发布成功");
		}
	}
	/**
	 * 作用在生产环境上 只被生产环境的接收同步请求的接口调用
	 */
	@Transactional
	@Override
	public JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception {
		// 获取团队
		IdeTeamBo teamBo = production.getIdeTeam();
		IdeTeam ideTeam = null;
		if(teamBo!=null){
			ideTeam = ideTeamRepo.findOne(teamBo.getId());
			ideTeam = ideTeam==null ? new IdeTeam() : ideTeam;
			BeanUtils.copyProperties(teamBo, ideTeam, "modifyDate");
			ideTeamRepo.save(ideTeam);
		}
		// 获取应用
		IdeAppBo appBo = production.getIdeApp();
		List<IdeApp> ideApps = ideAppRepo.findAllByCode(appBo.getCode());
		// 更新应用
		IdeApp ideApp = (ideApps==null || ideApps.isEmpty())? new IdeApp() : ideApps.get(0);
		BeanUtils.copyProperties(appBo, ideApp, new String[]{"id","modifyDate"});
		if(ideTeam!=null)ideApp.setTeamId(ideTeam.getId());
		ideApp.setCreateDate(new Date());
		ideAppRepo.save(ideApp);
		// 获取页面
		List<IdeModuleBo> moduleBos = production.getIdeModules();
		// 记录发布失败的页面
		List<String> failPages = new ArrayList<String>();
		// 更新页面
		if(moduleBos!=null&&moduleBos.size()>0){
			for(IdeModuleBo moduleBo:moduleBos){
				try{
					IdeModule ideModule = ideModuleRepo.findByCode(moduleBo.getCode(), String.valueOf(ideApp.getId()));
					ideModule = ideModule==null ? new IdeModule() : ideModule;
					BeanUtils.copyProperties(moduleBo, ideModule, new String[]{"id","appId","modifyDate"});
					ideModule.setAppId(ideApp.getId());
					ideModule.setModifyDate(new Date());
					ideModuleRepo.update(ideModule);
					// 保存到发布历史记录
					this.publishHistory(ideModule,production.getFromName(),production.getToName());
				}catch(Exception e){
					failPages.add("["+moduleBo.getCode()+"]"+moduleBo.getName());
				}
			}
		}
		return JsonBackData.toSuccess("发布成功",failPages);
	}
	
	@Override
	public Page<IdeModule> findModulesByAppId(String appId,String searchText,boolean isDelete,Pageable pageable) throws Exception {
		Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
		List<IdeModule> ideModules = ideModuleRepo.findModuleListByAppId(appId,searchText,isDelete,pageIndex,pageable.getPageSize());
		
		Long total = ideModuleRepo.findModuleCountByAppId(appId,searchText,isDelete);
		Page<IdeModule> page = new PageImpl<>(ideModules, pageable, total);
		return page;
	}
	
	@Override
	public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
		String moduleIds = "";
		if(ids != null && ids.size() > 0) {
			for(String id:ids) {
				moduleIds += id + ",";
			}
			moduleIds = moduleIds.substring(0, moduleIds.length()-1);
			List<IdeModulePrivate> modulePrivates = ideModulePrivateRepo.findListByModuleIds(moduleIds);
			return modulePrivates;
		}
		return null;
	}
	
	@Override
	public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
		String idStr = "";
		for(String id:ids) {
			idStr += id + ",";
		}
		if(StringUtils.isNotBlank(idStr)) {
			idStr = idStr.substring(0, idStr.length()-1);
		}
		if (isRemove) {
			ideModuleRepo.removeByIds(idStr);
			ideModulePrivateRepo.removeByModuleIds(idStr);
		}else {	
			ideModuleRepo.deleteByIds(idStr);
	        moduleDataRepo.deleteByModuleIds(idStr);
	        ideModulePrivateRepo.deleteByModuleIds(idStr);
		}
	}

	@Override
	public void restoreByIds(List<String> ids) throws BusinessException, Exception {
		String idStr = "";
		if(ids != null && ids.size() > 0) {
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			ideModuleRepo.recoverByIds(idStr);
			ideModulePrivateRepo.recoverByModuleIds(idStr);
		}
	}

	@Override
	public JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException, Exception {
		if(pageIds != null && pageIds.size() > 0) {
			String pageIdStr = "";
			for(String pageId:pageIds) {
				pageIdStr += pageId + ",";
			}
			pageIdStr = pageIdStr.substring(0, pageIdStr.length()-1);
			ideModuleRepo.movePagesByAppId(pageIdStr, appId);
		}
		return JsonBackData.toSuccess("迁移成功");
	}

	@Override
	public List<IdeModule> findByIds(List<String> ids) {
		if(ids != null && ids.size() > 0) {
			String idStr = "";
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			return ideModuleRepo.findByIds(idStr);
		}
		return null;
	}
}
