package com.ejianc.foundation.front.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class TimeUtils {
	public static final String DF_SIMPLE_YM = "yyyyMM";
	public static final String DF_SIMPLE_YMDHMS = "yyyyMMddHHmmss";
	public static final String DF_YMDHMS = "yyyy-MM-dd_HH_mm_ss";
	public static final String DF_ZH_YM = "yyyy-MM";
	public static final String DF_ZH_YMD = "yyyy-MM-dd";
	public static final String DF_ZHCN_YMD = "yyyy年MM月dd日";
	public static final String DF_ZH_HMS = "HH:mm:ss";
	public static final String DF_ZH_YMDHMS = "yyyy-MM-dd HH:mm:ss";
	public static final String DF_ZHCN_YMDHM = "yyyy年MM月dd日HH时mm分";
	public static final String DF_ZHCN_YMDHMS = "yyyy年MM月dd日HH时mm分ss秒";

	public static Date stringToDate(String dateString, String dateFormat) {
		try {
			return new SimpleDateFormat(dateFormat).parse(dateString);
		} catch (NullPointerException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (ParseException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static Date stringToDate(String dateString) {
		return stringToDate(dateString, "yyyy-MM-dd HH:mm:ss");
	}

	public static String dateToString(Date date, String dateFormat) {
		try {
			return new SimpleDateFormat(dateFormat).format(date);
		} catch (NullPointerException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String dateToStringSimple(Date date) {
		return dateToString(date, "yyyy-MM-dd");
	}

	public static String dateToString(Date date) {
		return dateToString(date, "yyyy-MM-dd HH:mm:ss");
	}

	public static String getTodayString(String format) {
		return dateToString(new Date(), format);
	}

	public static String getTodayString() {
		return getTodayString("yyyy-MM-dd");
	}

	public static String getTodayStringZhCN() {
		return getTodayString("yyyy��MM��dd��");
	}

	public static String getNowTime() {
		return getTodayString("HH:mm:ss");
	}

	public static String getNowDateTime() {
		return getTodayString("yyyy-MM-dd HH:mm:ss");
	}

	public static String getNowDateTimeZhCN() {
		return getTodayString("yyyy��MM��dd��HH��mm��ss��");
	}

	public static String getTomorrowString() {
		GregorianCalendar tomorrow = new GregorianCalendar();
		tomorrow.add(5, 1);
		return dateToString(tomorrow.getTime(), "yyyy-MM-dd");
	}

	public static String getYesterdayString() {
		GregorianCalendar yesterday = new GregorianCalendar();
		yesterday.add(5, -1);
		return dateToString(yesterday.getTime(), "yyyy-MM-dd");
	}

	public static String getPrevMonthString(Date oneday) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(oneday);
		calendar.set(2, calendar.get(2) - 1);
		return dateToString(calendar.getTime(), "yyyy-MM");
	}

	public static String getNextMonthDateString() {
		return getNextMonthDateString(new Date());
	}

	public static String getNextMonthDateString(Date date) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.set(2, calendar.get(2) + 1);
		return dateToString(calendar.getTime(), "yyyy-MM-dd");
	}

	public static Date setDateYear(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(1, movNum);
		return now.getTime();
	}

	public static Date setDateMonth(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(2, movNum);
		return now.getTime();
	}

	public static Date setDateDay(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(5, movNum);
		return now.getTime();
	}

	public static Date setDateHour(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(11, movNum);
		return now.getTime();
	}

	public static Date setDateMinute(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(12, movNum);
		return now.getTime();
	}

	public static Date setDateSecond(Date date, int movNum) {
		GregorianCalendar now = new GregorianCalendar();
		now.setTime(date);
		now.add(13, movNum);
		return now.getTime();
	}

	public static int nDaysBetweenTwoDate(Date firstDate, Date secondDate) {
		return (int) ((stringToDate(dateToString(secondDate, "yyyy-MM-dd"), "yyyy-MM-dd").getTime()
				- stringToDate(dateToString(firstDate, "yyyy-MM-dd"), "yyyy-MM-dd").getTime()) / 86400000L);
	}

	public static String parseUseTime(Date begin, Date end) {
		if ((begin != null) && (end != null)) {
			long useTime = end.getTime() - begin.getTime();
			return parseUseTime(useTime);
		}
		return "";
	}

	public static String parseUseTime(long useTime) {
		long s = 1000L;
		long m = s * 60L;
		long h = m * 60L;
		long d = h * 24L;
		String dd = Long.toString(useTime / d);
		String HH = Long.toString(useTime % d / h);
		String mm = Long.toString(useTime % d % h / m);
		String ss = Long.toString(useTime % d % h % m / s);
		return dd + "��" + HH + "��" + mm + "��" + ss + "��";
	}

	public static String parseWorkUseTime(long useTime) {
		long s = 1000L;
		long m = s * 60L;
		long h = m * 60L;
		long d = h * 8L;
		String dd = Long.toString(useTime / d);
		String HH = Long.toString(useTime % d / h);
		String mm = Long.toString(useTime % d % h / m);
		String ss = Long.toString(useTime % d % h % m / s);
		return dd + "��" + HH + "��" + mm + "��" + ss + "��";
	}

	public static int getWorkDays(Date bofDate, Date eofDate) {
		int days = 0;
		if ((bofDate != null) && (eofDate != null)) {
			Calendar bofWork = Calendar.getInstance();
			Calendar eofWork = Calendar.getInstance();
			bofWork.setTime(bofDate);
			eofWork.setTime(eofDate);
			Calendar tmp = Calendar.getInstance();
			tmp.setTime(bofWork.getTime());
			while ((tmp.get(1) == eofWork.get(1)) && (tmp.get(6) <= eofWork.get(6))) {
				if ((tmp.get(7) != 1) && (tmp.get(7) != 7)) {
					days++;
				}
				tmp.add(6, 1);
			}
		}
		return days;
	}

	public static String toDateString(Calendar calendar) {
		return calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":"
				+ calendar.get(12) + ":" + calendar.get(13) + "." + calendar.get(14);
	}

	public static String calHours(Date beginOperateTime, Date endOperateBeginTime) {
		try {
			long mSeconds = endOperateBeginTime.getTime() - beginOperateTime.getTime();
			return String.valueOf(mSeconds / 3600000L);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Deprecated
	public static String getTime10(Object... params) {
		return getTime("yyyy-MM-dd", params);
	}

	@Deprecated
	public static String getTime14(Object... params) {
		return getTime("yyyyMMddHHmmss", params);
	}

	@Deprecated
	public static String getTime16(Object... params) {
		return getTime("yyyy-MM-dd HH:mm", params);
	}

	@Deprecated
	public static String getTime19(Object... params) {
		return getTime("yyyy-MM-dd HH:mm:ss", params);
	}

	@Deprecated
	public static String getTime(String pat, Object... params) {
		SimpleDateFormat sdf = new SimpleDateFormat(pat);
		if ((params == null) || (params.length == 0)) {
			return sdf.format(new Date(System.currentTimeMillis()));
		}
		if (params.length == 1) {
			if ((params[0] instanceof Date)) {
				return sdf.format((Date) params[0]);
			}
			return "";
		}
		if (params.length == 2) {
			Calendar c = Calendar.getInstance();
			c.setTime((Date) params[0]);
			c.add(6, ((Integer) params[1]).intValue());

			return sdf.format(c.getTime());
		}
		if (params.length == 3) {
			Calendar c = Calendar.getInstance();
			c.setTime((Date) params[0]);
			c.add(((Integer) params[2]).intValue(), ((Integer) params[1]).intValue());

			return sdf.format(c.getTime());
		}
		return null;
	}

	public static Timestamp getTimestamp(Date date) {
		return new Timestamp(date.getTime());
	}

	public static int getDateYear(Date d) {
		Calendar now = Calendar.getInstance(TimeZone.getDefault());
		now.setTime(d);
		return now.get(1);
	}

	public static int getDateMonth(Date d) {
		Calendar now = Calendar.getInstance(TimeZone.getDefault());
		now.setTime(d);
		return now.get(2) + 1;
	}

	public static int getDateHour(Date d) {
		Calendar now = Calendar.getInstance(TimeZone.getDefault());
		now.setTime(d);
		return now.get(11);
	}

	public static int getDateMin(Date d) {
		Calendar now = Calendar.getInstance(TimeZone.getDefault());
		now.setTime(d);
		return now.get(12);
	}

	public static int getDateSecond(Date d) {
		Calendar now = Calendar.getInstance(TimeZone.getDefault());
		now.setTime(d);
		return now.get(13);
	}

	public static long getMicroSec(BigDecimal hours) {
		BigDecimal bd = hours.multiply(new BigDecimal(3600000));
		return bd.longValue();
	}

	public static String getYearMonthOfLastMonth(Date d) {
		Date newdate = setDateMonth(d, -1);
		return dateToString(newdate, "yyyyMM");
	}

	public static String getYearMonthOfThisMonth() {
		Date newdate = setDateMonth(new Date(), -1);
		return dateToString(newdate, "yyyyMM");
	}

	public static String getHalfYearBeforeStr(Date d) {
		return dateToString(setDateMonth(d, -6), "yyyy-MM-dd");
	}

	public static int getCurentMonthDays() {
		return getMonthDays(new Date());
	}

	public static int getMonthDays(Date d) {
		Calendar c = Calendar.getInstance();
		c.setTime(new Date());
		return c.getActualMaximum(5);
	}

	public static List<Map<String, Object>> convertListDateToString(List<Map<String, Object>> list, String dateFormat) {
		if (list == null) {
			return null;
		}
		if ((dateFormat == null) || ("".equals(dateFormat))) {
			dateFormat = "yyyy-MM-dd HH:mm:ss";
		}
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> row = list.get(i);
			for (Map.Entry<String, Object> col : row.entrySet()) {
				if ((col.getValue() instanceof Date)) {
					String dateStr = dateToString((Date) col.getValue(), dateFormat);
					col.setValue(dateStr);
				}
			}
		}
		return list;
	}

	public static Date getDate(String dateStr, String fmt) {
		try {
			return new SimpleDateFormat(fmt).parse(dateStr);
		} catch (ParseException e) {
		}
		return null;
	}

	public static String getDateFormat(String dataStr) {
		String spDay = "-?";
		String spTime = ":?";
		String sp = "\\s";
		String yyyy = "\\d{4}";
		String MM = "\\d{1,2}";
		String dd = "\\d{1,2}";
		String HH = "\\d{1,2}";
		String mm = "\\d{1,2}";
		String ss = "\\d{1,2}";
		if (Pattern.matches(yyyy + spDay + MM, dataStr)) {
			return "yyyy-MM";
		}
		if (Pattern.matches(yyyy + spDay + MM + spDay + dd, dataStr)) {
			return "yyyy-MM-dd";
		}
		if (Pattern.matches(yyyy + spDay + MM + spDay + dd + sp + HH + spTime + mm, dataStr)) {
			return "yyyy-MM-dd HH:mm";
		}
		if (Pattern.matches(yyyy + spDay + MM + spDay + dd + sp + HH + spTime + mm + spTime + ss, dataStr)) {
			return "yyyy-MM-dd HH:mm:ss";
		}
		if (Pattern.matches(HH + spTime + mm + spTime + ss, dataStr)) {
			return "HH:mm:ss";
		}
		if (Pattern.matches(HH + spTime + mm, dataStr)) {
			return "HH:mm";
		}
		return null;
	}
}
