package com.ejianc.foundation.front.business.ide.bo;

import java.io.Serializable;
import java.text.SimpleDateFormat;

import com.ejianc.foundation.front.business.ide.entity.IdeUser;

public class IdeAccountBo implements Serializable {
	private static final long serialVersionUID = -2222276822417645703L;
	
	private String gid;
	private String code;
	private String password;//明码
	private String passwordMd5;//加密
	private String name;//名称
	
	private int sex;//0-男、1-女
	private String expireDate;
	private String createdDate;
	private String qqAvatarUrl;//QQ头像URL
	public IdeAccountBo() {
	}
	
	public IdeAccountBo(IdeUser bean){
		if(bean==null)return;
		this.gid = bean.getId() + "";
		this.code =bean.getCode();
		this.passwordMd5=bean.getPassword();
		this.name=bean.getName();
		this.sex = bean.getSex();
		this.expireDate = bean.getExpireDate()!=null?new SimpleDateFormat("yyyy-MM-dd").format(bean.getExpireDate()):null;
		this.createdDate = bean.getCreateDate()!=null?new SimpleDateFormat("yyyy-MM-dd").format(bean.getCreateDate()):null;
		this.qqAvatarUrl = bean.getQqAvatarUrl();
	}
	
	public String getGid() {
		return gid;
	}

	public void setGid(String gid) {
		this.gid = gid;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}

	public String getPasswordMd5() {
		return passwordMd5;
	}

	public void setPasswordMd5(String passwordMd5) {
		this.passwordMd5 = passwordMd5;
	}

	public int getSex() {
		return sex;
	}

	public void setSex(int sex) {
		this.sex = sex;
	}

	public String getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(String expireDate) {
		this.expireDate = expireDate;
	}

	public String getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(String createdDate) {
		this.createdDate = createdDate;
	}

	public String getQqAvatarUrl() {
		return qqAvatarUrl;
	}

	public void setQqAvatarUrl(String qqAvatarUrl) {
		this.qqAvatarUrl = qqAvatarUrl;
	}
}
