package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;


@RestController
@RequestMapping(value = "/ide/module/publish")
public class IdeModuleProController {

    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModuleService ideModuleService;
    
    /**
     * 删除指定的页面发布历史记录
     * @param pageId
     * @return
     */
    @RequestMapping(value="{pageId}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable String pageId) {
    	try {
        	ideModuleProService.deleteById(pageId);
        	return JsonBackData.toSuccess("发布删除成功");
        } catch (Exception e) {
            e.printStackTrace();
        	return JsonBackData.toError(e.getMessage());
        }
    }
    /**
     * 查询指定应用下全部已发布的页面历史记录
     * @return
     */
    @RequestMapping(method=RequestMethod.GET)
    public JsonBackData list(String appId) {
    	try {
        	List<IdeModulePro> module = ideModuleProService.findAllLastPublishByAppId(appId);
        	return JsonBackData.toSuccess("发布查询成功", module);
        } catch (Exception e) {
            e.printStackTrace();
        	return JsonBackData.toError(e.getMessage());
        }
    }
	
}
