package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;
import com.ejianc.foundation.front.business.ide.service.IdeUiDefineService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@Controller
@RequestMapping(value = "ide/uiDefine")
public class IdeUiDefineController {

	@Autowired
	private IdeUiDefineService ideUiDefineService;
	
	@ResponseBody
	@RequestMapping(value = "showList" ,method = RequestMethod.POST)
	public JsonBackData showList(@RequestBody Map<String, Object> query) {
		JsonBackData back = new JsonBackData();
		String searchText = (String)query.get("searchText");
		try {
			back.setBackData(ideUiDefineService.findList(searchText));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "saveOrUpdate",method = RequestMethod.POST)
	public JsonBackData saveOrUpdate(@RequestBody IdeUiDefine bo){
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideUiDefineService.saveOrUpdate(bo));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "delete",method = RequestMethod.POST)
	public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query){
		JsonBackData back = new JsonBackData();
		List<String> ids = (List<String>) query.get("ids");
		try {
			ideUiDefineService.deleteByIds(ids);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
		@ResponseBody
		@RequestMapping(value = "findByCode")
		public JsonBackData findByUrl(@RequestParam String code) {
			JsonBackData back = new JsonBackData();
			try {
				back.setBackData(ideUiDefineService.findByCode(code));
			} catch (BusinessException ex) {
				back.setSuccess(false);
				back.setBackMsg(ex.getMessage());
			} catch (Exception ex) {
				ex.printStackTrace();
				back.setSuccess(false);
				back.setBackMsg("获取数据失败！");
			}
			return back;
		}
}
