package com.ejianc.foundation.front.business.ide.filter;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.framework.core.context.InvocationInfoProxy;

public class PermissionInterceptor implements HandlerInterceptor {
	final String SESSION_USER_KEY = "sess_user"; 
	
	public List<String> excludeConfig(){
		List<String> resultList = new ArrayList<>();
		resultList.add("ide/account");
		return resultList;
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response,Object handler) throws Exception {
		System.out.println("PermissionInterceptor.preHandle[" + request.getRequestURL() + ".." + handler.getClass().getSimpleName() + "]...");
		String requestUri = request.getRequestURI();
		List<String> excludeUrls = excludeConfig();
		/*boolean isExclude = false;
		for(String pattern : excludeUrls) {
			if(requestUri.indexOf(pattern) != -1) {
				isExclude = true;
				break;
			}
		}
		if(isExclude){
			//直接放行 
			
			return true;
		}else{
			IdeAccountBo account = (IdeAccountBo)request.getSession().getAttribute(SESSION_USER_KEY);
			if(account == null) {
				return false;
			}else{
				InvocationInfoProxy.setTenantid(999999l);
				InvocationInfoProxy.setUserid(Long.parseLong(account.getGid()));
				MDC.put("current_tenant_id", "999999");
			}
		}*/
		IdeAccountBo account = (IdeAccountBo)request.getSession().getAttribute(SESSION_USER_KEY);
		if(account != null) {
			InvocationInfoProxy.setTenantid(999999l);
			InvocationInfoProxy.setUserid(Long.parseLong(account.getGid()));
			MDC.put("current_tenant_id", "999999");
		}
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response,Object handler, ModelAndView mv) throws Exception {
		System.out.println("PermissionInterceptor.postHandle[" + request.getRequestURL() + ".." + handler.getClass().getSimpleName() + "]...");
	
	}

	@Override
	public void afterCompletion(HttpServletRequest request,HttpServletResponse response, Object handler, Exception ex) throws Exception {
		System.out.println("PermissionInterceptor.afterCompletion[" + request.getRequestURL() + ".." + handler.getClass().getSimpleName() + "]...");
		if (ex == null) {
			//记录操作日志
		} else {
			System.out.println("ExceptionInterceptor.afterCompletion[" + request.getRequestURL() + ".." + handler.getClass().getSimpleName() + "]出现异常...");
			ex.printStackTrace();
		}
	}

}
