package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.ejianc.foundation.front.business.ide.bo.IdeUiDefineBO;
import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;
import com.ejianc.framework.core.exception.BusinessException;

public interface IdeUiDefineService {

    List<IdeUiDefine> findList(String seachText) throws BusinessException, Exception;

    IdeUiDefine saveOrUpdate(IdeUiDefine ideUiDefine) throws BusinessException, Exception;

    IdeUiDefineBO findByCode(String code) throws BusinessException, Exception;

    void deleteByIds(List<String> ids) throws BusinessException, Exception;

    /** 
     * 删除组件
     *
     * @param id id
     */
    void delete(String id);

    /**
     * 删除文件下下所有组件
     *
     * @param folderId 文件夹id
     */
    void deleteByFolderId(String folderId);

    /**
     * 查找文件下下所有组件
     *
     * @param folderId 文件夹id
     * @param searchText 模糊匹配文本
     * @return 组件列表
     */
    List<IdeUiDefineBO> findByFolderId(String folderId, String searchText);
}
