package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Transactional(readOnly = true)
@Service
public class IdeModuleGroupServiceImpl implements IdeModuleGroupService {
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    private IdeModuleGroupRepo moduleGroupRepo;
    @Autowired
    private IdeModuleRepo ideModuleRepo;

    @Transactional
    @Override
    public IdeModuleGroup save(IdeModuleGroup moduleGroup) {
        boolean isAdd = StringUtils.isEmpty(moduleGroup.getId());
        if (isAdd) {//创建组
        	moduleGroup.setId(IdWorker.getId());
            moduleGroup.setCode(ideCommonService.generateModuleGroupCode());
            moduleGroup.setCreateDate(new Date());
            moduleGroup.setCreateId(InvocationInfoProxy.getUserid());
            moduleGroupRepo.save(moduleGroup);
        } else {//修改组
            IdeModuleGroup _moduleGroup = moduleGroupRepo.findOne(moduleGroup.getId());
            _moduleGroup.setName(moduleGroup.getName());
            _moduleGroup.setModifyDate(new Date());
            _moduleGroup.setModifyId(InvocationInfoProxy.getUserid());
            moduleGroupRepo.update(_moduleGroup);
        }

        return moduleGroup;
    }

    @Transactional
    @Override
    public void deleteById(String id) {
        IdeModuleGroup moduleGroup = moduleGroupRepo.findOne(Long.parseLong(id));
        if (moduleGroup == null) {
            throw new BusinessException("该应用模块不存在或已被删除!");
        }
        moduleGroupRepo.logicDel(moduleGroup.getId());
    }

    @Transactional
    @Override
    public void deleteByIds(String[] ids) {
        Arrays.stream(ids).forEach(this::deleteById);
        String idStr = "";
        if(ids != null && ids.length > 0) {
        	for(String id:ids) {
        		idStr += id + ",";
        	}
        	ideModuleRepo.updateGroupId(idStr.substring(0, idStr.length()-1));
        }
    }

    @Override
    public IdeModuleGroup findById(String id) {
        return moduleGroupRepo.findOne(Long.parseLong(id));
    }

    @Override
    public List<IdeModuleGroup> findByAppId(String appId) {
        return moduleGroupRepo.findByAppId(appId);
    }
}
