package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.ejianc.foundation.front.business.ide.bo.IdeUiDefineBO;
import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;
import com.ejianc.foundation.front.business.ide.repository.IdeUiDefineRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUiDefineService;
import com.ejianc.framework.core.exception.BusinessException;

@Transactional
@Service
public class IdeUiDefineServiceImpl implements IdeUiDefineService{
	 @Autowired
	 private IdeUiDefineRepo ideUiDefineRepo;
	@Override
	public List<IdeUiDefine> findList(String searchText) throws BusinessException, Exception {
		List<IdeUiDefine> ideUiDefines = ideUiDefineRepo.findBySearchText(searchText);
		return ideUiDefines;
	}

	@Override
	public IdeUiDefine saveOrUpdate(IdeUiDefine ideUiDefine) throws BusinessException, Exception {
		//新增
		IdeUiDefine entity = ideUiDefineRepo.findById(String.valueOf(ideUiDefine.getId()));
		if (entity == null) {
			IdeUiDefine uiDefine = ideUiDefineRepo.findByCode(ideUiDefine.getCode());
			if (uiDefine != null) {
				throw new BusinessException("该组件编码已存在！");
			}else {
				ideUiDefine.setCreateDate(new Date());
				return ideUiDefineRepo.save(ideUiDefine);
			}
		//修改
		}else{
			IdeUiDefine uiDefine = ideUiDefineRepo.findByCode(ideUiDefine.getCode());
			if (uiDefine != null && !uiDefine.getCode().equals(ideUiDefine.getCode())) {
				throw new BusinessException("该组件编码已存在！");
			}
			else {
				entity.setCode(ideUiDefine.getCode());
				entity.setParser(ideUiDefine.getParser());
				entity.setName(ideUiDefine.getName());
				entity.setDefaults(ideUiDefine.getDefaults());
				entity.setIcon(ideUiDefine.getIcon());
				entity.setIncludeType(ideUiDefine.getIncludeType());
				entity.setIncludeContents(ideUiDefine.getIncludeContents());
				entity.setModifyDate(new Date());
				return ideUiDefineRepo.update(entity);
			}
		}
		
	}

	@Override
	public IdeUiDefineBO findByCode(String code) throws BusinessException, Exception {
		IdeUiDefine uiDefine  = ideUiDefineRepo.findByCode(code);
		if (uiDefine != null) {
			IdeUiDefineBO bo = new IdeUiDefineBO();
			bo.setId(String.valueOf(uiDefine.getId()));
			bo.setCode(uiDefine.getCode());
			bo.setDefaults(uiDefine.getDefaults());
			bo.setIcon(uiDefine.getIcon());
			bo.setIncludeContents(uiDefine.getIncludeContents());
			bo.setIncludeType(uiDefine.getIncludeType());
			bo.setName(uiDefine.getName());
			bo.setParser(uiDefine.getParser());
			List<IdeUiDefine> allData = ideUiDefineRepo.findAllData();
	       if (!StringUtils.isEmpty(uiDefine.getIncludeContents())) {
	    	   String [] codes = uiDefine.getIncludeContents().split(",");
	    	   StringBuffer codeBuffer = new StringBuffer("'");
	    	   for(String codeString:codes) {
	    		   codeBuffer.append(codeString).append("','");
	    	   }
	       	   List<IdeUiDefine> rightData = ideUiDefineRepo.findByCodes(codeBuffer.substring(0, codeBuffer.length()-2));
	       	   allData.removeAll(rightData);
	       	   bo.setLeftData(allData);
	       	   bo.setRightData(rightData);
	       }else {
			bo.setLeftData(allData);
	       }
	       return bo;
		}
		return null;
	}

	@Override
	public void deleteByIds(List<String> ids) throws BusinessException, Exception {
		if(ids != null && ids.size() > 0) {
			StringBuffer idStr = new StringBuffer("'");
			for(String id:ids) {
				idStr.append(id).append("','");
			}
			ideUiDefineRepo.deleteByIds(idStr.toString().substring(0, idStr.length()-2));
		}
	}

	/**
	 * 删除组件
	 *
	 * @param id id
	 */
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void delete(String id) {
		ideUiDefineRepo.deleteByIds(id);
	}

	/**
	 * 删除文件下下所有组件
	 *
	 * @param folderId 文件夹id
	 */
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void deleteByFolderId(String folderId) {
		List<IdeUiDefine> defines = ideUiDefineRepo.findByFolderId(folderId);
		defines.forEach(define -> delete(String.valueOf(define.getId())));
	}

	/**
	 * 查找文件下下所有组件
	 *
	 * @param folderId 文件夹id
	 * @param searchText 模糊匹配文本
	 * @return 组件列表
	 */
	@Transactional(readOnly = true, rollbackFor = Exception.class)
	@Override
	public List<IdeUiDefineBO> findByFolderId(String folderId, String searchText) {
		List<IdeUiDefine> defines = StringUtils.isEmpty(searchText) ? ideUiDefineRepo.findByFolderId(folderId) :
				ideUiDefineRepo.findByFolderIdAndSearchText(folderId, searchText);
		return defines.stream().map(item -> {
			IdeUiDefineBO define = new IdeUiDefineBO();
			BeanUtils.copyProperties(item, define);
			return define;
		}).collect(Collectors.toList());
	}
}
