package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 应用管理服务
 */
@RestController
@RequestMapping(value = "/ide/app")
public class IdeAppController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeAppController.class);

    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeModuleService ideModuleService;

    /**
     * 查找当前用户创建的应用（包含公开的模板应用）
     * @param userId
     * @return
     */
    @Deprecated
    @RequestMapping(value="findByUser",method = RequestMethod.GET)
    public JsonBackData findByUser(@RequestParam String userId,@RequestParam(value="clientType",required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> ideAppBos = ideAppService.findByCreateId(userId,clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }
    /**
     * 通过应用编码获取应用信息
     * @param code
     * @return
     */
    @RequestMapping(value="findByCode",method = RequestMethod.GET)
    public JsonBackData findByCode(@RequestParam String code) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		IdeApp ideApp = ideAppService.findByCode(code);
    		backData.setBackData(ideApp);
    		backData.setBackMsg("成功");
    	} catch (Exception e) {
    		e.printStackTrace();
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }
    /**
     * 查找当前用户所属团队下的全部应用，按团队进行分组
     * @param userId
     * @param prodType 产品类型
     * @return
     */
    @RequestMapping(value="teamapps",method = RequestMethod.GET)
    public JsonBackData findTeamAppsByUser(@RequestParam String userId, @RequestParam(value = "prodType", defaultValue = "0") int prodType,
    									   @RequestParam(value="clientType", required=false) String clientType) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		List<IdeTeamBo> ideAppBos = ideAppService.findTeamAppsByUser(userId, prodType, clientType);
    		backData.setBackData(ideAppBos);
    		backData.setBackMsg("成功");
    	} catch (Exception e) {
    		e.printStackTrace();
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }
    /**
     *  查找非当前用户所属团队下的公开应用，按团队进行分组
     * @param userId
     * @param prodType 产品类型
     * @return
     */
    @RequestMapping(value="publicapps",method = RequestMethod.GET)
    public JsonBackData findTeamPublicApps(@RequestParam String userId, @RequestParam(value = "prodType", defaultValue = "0") int prodType,
    										@RequestParam(value="clientType",required=false) String clientType) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		List<IdeTeamBo> ideAppBos = ideAppService.findTeamPublicApps(userId, prodType,clientType);
    		backData.setBackData(ideAppBos);
    		backData.setBackMsg("成功");
    	} catch (Exception e) {
    		e.printStackTrace();
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }
    
    @RequestMapping(value="noteam/{userId}",method = RequestMethod.GET)
    public JsonBackData findNoTeamApps(@PathVariable String userId,@RequestParam(value="clientType",required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> ideAppBos = ideAppService.findNoTeamApps(userId,clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeApp ideApp) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.saveOrUpdate(ideApp);
            backData.setSuccess(true);
            backData.setBackMsg("保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }
    /**
     * 逻辑删除
     * @param id
     * @return
     */
    @RequestMapping(value = "{id}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.deleteById(id);
            backData.setBackMsg("删除成功");
        } catch (Exception e) {
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }
    /**
     * 彻底删除
     * @param id
     * @return
     */
    @RequestMapping(value = "remove/{id}", method = RequestMethod.DELETE)
    public JsonBackData remove(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.removeById(id);
            backData.setBackMsg("删除成功");
        } catch (Exception e) {
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }
    /**
     * 恢复已删除
     * @param id
     * @return
     */
    @RequestMapping(value = "recover/{id}", method = RequestMethod.POST)
    public JsonBackData recover(@PathVariable String id) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		ideAppService.recoverById(id);
    		backData.setBackMsg("恢复成功");
    	} catch (Exception e) {
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }

//    @RequestMapping(value="delete", method = RequestMethod.GET)
//    public JsonBackData deleteWithIds(@RequestParam(value = "ids") String[] ids) {
//        JsonBackData backData = new JsonBackData();
//        try {
//            ideAppService.deleteByIds(ids);
//            backData.setBackMsg("删除成功");
//        } catch (Exception e) {
//            backData.setBackMsg("系统错误");
//            backData.setSuccess(false);
//        }
//        return backData;
//    }
    
    @RequestMapping(value="pages", method = RequestMethod.POST)
    public JsonBackData findAppPages(@RequestBody String[] appIds) {
        JsonBackData backData = new JsonBackData();
        try {
        	backData.setBackData(ideModuleService.findInAppIds(appIds));
            backData.setBackMsg("获取页面基础数据成功");
            backData.setSuccess(true);
        } catch (Exception e) {
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value = "{appId}/module", method = RequestMethod.GET)
    public JsonBackData module(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeModule> result = ideModuleService.findByAppId(appId);
            backData.setBackData(result);
        } catch (BusinessException e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("系统错误");
        }
        return backData;
    }
    @RequestMapping(value = "{appId}/moduleIsDelete", method = RequestMethod.GET)
    public JsonBackData moduleIsDelete(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeModule> result = ideModuleService.findIsDeleteModules(appId);
            backData.setBackData(result);
        } catch (BusinessException e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("系统错误");
        }
        return backData;
    }

    /**
     * 复制应用
     * @param ideApp
     * @return
     */
    @RequestMapping(value = "copy", method = RequestMethod.POST)
    public JsonBackData copy(@RequestBody IdeApp ideApp) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.copyApp(ideApp);
            backData.setBackMsg("操作成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("系统错误");
        }
        return backData;
    }

    /**
     * 设置应用是否公开
     * @param open
     * @param id
     * @param createId
     * @return
     */
    @RequestMapping(value = "open", method = RequestMethod.POST)
    public JsonBackData open(@RequestParam(required = true,value="open",defaultValue="0")int open, @RequestParam String id, @RequestParam String createId) {
    	try {
    		ideAppService.updateOpen(id,open,createId);
    		return JsonBackData.toSuccess("公开成功");
    	} catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError("系统错误");
        }
    }
    
    @RequestMapping(value = "all", method = RequestMethod.GET)
    public JsonBackData allApps(@RequestParam(value = "isDelete") boolean isDelete,@RequestParam(value="clientType",required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> result = ideAppService.findAllApps(isDelete,clientType);
            backData.setSuccess(true);
            backData.setBackData(result);
        } catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    /**
     * 绑定应用其所属的团队
     *
     * @param teamId 团队id
     * @param appIds 应用id数组
     *
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "bindteam", method = RequestMethod.POST)
    public JsonBackData bindTeamOfApps(@RequestParam String teamId,@RequestBody String[] appIds,@RequestParam String groupId) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.bindTeamOfApps(teamId, appIds,groupId);
            backData.setBackMsg("绑定应用其所属的团队成功");
        } catch (BusinessException e) {
            LOGGER.error("绑定应用其所属的团队失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("绑定应用其所属的团队失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("绑定应用其所属的团队失败");
        }
        return backData;
    }
}
