package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;

/**
 * 提供给开发者开放平台使用
 */
@Mapper
public interface IdeAppOpenRepo {

    /**
     * 统计指定项目下名称相同的应用个数
     * @param name
     * @param productId
     * @return
     */
    Long countNameInProduct(@Param("name") String name,@Param("productId") String productId);
    
    /**
     * 获取指定项目下的全部应用按分组及名称排序
     * @param productId
     * @return
     */
    List<IdeApp> findProductApps(@Param("productId") String productId);
    
    
    /**
     * 查找指定项目下名称相同的对象
     * @param name
     * @param productId
     * @return
     */
    IdeAppGroup findAppGroupByProductIdAndName(@Param("productId") String productId,@Param("name") String name);
    
    /**
     * 获取指定项目下的全部分组
     * @param productId
     * @return
     */
    List<IdeAppGroup> findProductAppGroups(@Param("productId") String productId);
    /**
     * 查找指定的分组并按名称排序
     * @param ids
     * @return
     */
	List<IdeAppGroup> findAppGroupByIds(@Param("ids") String ids);
	
	/**
	 * 统计每个产品下面的应用个数
	 * @param productIds
	 * @return
	 */
	List<Map<String, Object>> findProductAppCount(@Param("productIds") String productIds);
}
