package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.ejianc.foundation.front.business.ide.bo.IdeUiFolderBO;

/**
 * @author andy
 */
public interface IdeUiFolderService {

    /**
     * 创建文件夹
     *
     * @param folder 文件夹
     * @return 文件夹id
     */
    String create(IdeUiFolderBO folder);
 
    /**
     * 更新文件夹
     *
     * @param folder 文件夹
     */
    void update(IdeUiFolderBO folder);

    /**
     * 删除文件夹
     *
     * @param id id
     */
    void delete(String id);

    /**
     * 删除库下所有文件夹
     *
     * @param libraryId 库id
     */
    void deleteByLibraryId(String libraryId);

    /**
     * 查询文件夹详情
     *
     * @param id id
     * @param searchText 模糊匹配文本
     * @return 文件夹详情
     */
    IdeUiFolderBO queryDetail(String id, String searchText);

    /**
     * 查找库下下所有文件夹及组件
     *
     * @param libraryId 库id
     * @param searchText 模糊匹配文本
     * @return 文件夹列表
     */
    List<IdeUiFolderBO> findByLibraryId(String libraryId, String searchText);

    /**
     * 查找库下下所有文件夹
     *
     * @param libraryId 库id
     * @return 文件夹列表
     */
    List<IdeUiFolderBO> findLibraryFolders(String libraryId);
}
