package com.ejianc.foundation.front.business.ide.service.impl;

import static com.ejianc.foundation.front.business.ide.bo.UserMessageType.APPLY_JOIN;
import static com.ejianc.foundation.front.business.ide.bo.UserMessageType.VERSION_UPDATE;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.ApplyJoinMessageBO;
import com.ejianc.foundation.front.business.ide.bo.ApplyJoinUserInfoBO;
import com.ejianc.foundation.front.business.ide.bo.UserMessageType;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeUserRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUserMessageService;

/**
 * 用户消息service
 * Created by cdr_c on 2017/8/3.
 */
@Service
public class IdeUserMessageServiceImpl implements IdeUserMessageService {
	
	@Autowired
	private IdeTeamRepo ideTeamRepo;
	@Autowired
	private IdeUserRepo ideUserRepo;

    /**
     * 获取申请加入的消息
     *
     * @param userId 用户id
     * @return 申请加入的消息
     */
    @Override
    public List<ApplyJoinMessageBO> getApplyJoinMessage(String userId) {
    	List<ApplyJoinMessageBO> applyJoinMessageList = ideTeamRepo.findApplyListByUserId(userId);
    	if (!CollectionUtils.isEmpty(applyJoinMessageList)) {
    		String teamIds = "";
    		for(ApplyJoinMessageBO applyJoinMessageBO:applyJoinMessageList) {
    			teamIds += applyJoinMessageBO.getTeamId() + ",";
    		}
    		List<Map<String, Object>> results = ideUserRepo.findMapByTeamId(teamIds.substring(0, teamIds.length() - 1));
    		if (!CollectionUtils.isEmpty(results)) {
                Map<String, List<Map<String, Object>>> teamUsersMap = results.stream().collect(Collectors.groupingBy(item -> (String) item.get("teamId")));
                applyJoinMessageList.forEach(applyJoinMessage -> {
                    if (teamUsersMap.containsKey(applyJoinMessage.getTeamId())) {
                        List<Map<String, Object>> teamUsers = teamUsersMap.get(applyJoinMessage.getTeamId());
                        List<ApplyJoinUserInfoBO> userInfoList = teamUsers.stream().map(item -> {
                            ApplyJoinUserInfoBO userInfo = new ApplyJoinUserInfoBO();
                            userInfo.setUserId((String) item.get("userId"));
                            userInfo.setUserName((String) item.get("userName"));
                            userInfo.setUserCode((String) item.get("userCode"));
                            return userInfo;
                        }).collect(Collectors.toList());
                        applyJoinMessage.setUsers(userInfoList);
                    }
                });
            }
            return applyJoinMessageList.stream().filter(applyJoinMessage -> !CollectionUtils.isEmpty(applyJoinMessage.getUsers())).collect(Collectors.toList());

    	}
    	return null;
    }

    /**
     * 获取用户消息
     *
     * @param userId       用户id
     * @param messageTypes 消息类型数组
     * @return 用户消息
     */
    @Override
    public JSONObject getUserMessage(String userId, UserMessageType[] messageTypes) {
        JSONObject result = new JSONObject();
        for (UserMessageType messageType : messageTypes) {
            switch (messageType) {
                case APPLY_JOIN:
                    result.put(APPLY_JOIN.toString(), this.getApplyJoinMessage(userId));
                    break;
                case VERSION_UPDATE:
                	//TODO
                	result.put(VERSION_UPDATE.toString(), null);
                	break;
                default:
            }
        }
        return result;
    }
}
