package com.ejianc.foundation.front.common.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
	
	public static HttpResponse get(String url, List<NameValuePair> params){
		HttpClient httpClient = HttpClientBuilder.create().build();
        try {  
            // Get请求  
            HttpGet httpget = new HttpGet(url);  
            // 设置参数  
            String str = EntityUtils.toString(new UrlEncodedFormEntity(params));  
            httpget.setURI(new URI(httpget.getURI().toString() + "?" + str));  
            // 发送请求  
            HttpResponse httpresponse = httpClient.execute(httpget);
            return httpresponse;
//            // 获取返回数据
//            HttpEntity entity = httpresponse.getEntity();  
//            body = EntityUtils.toString(entity);  
//            if (entity != null) {  
//            	EntityUtils.consume(entity);
//        	}  
        } catch (Exception e) {  
            e.printStackTrace();  
        }
        return null;
	}
	
	/**  
     * 发送 Post请求  
     * @param url  
     * @param reqXml  
     * @return  
     */  
    public static HttpResponse postJSON(String url, String jsonString) {  
		HttpClient httpClient = HttpClientBuilder.create().build();
        try {  
            URIBuilder builder = new URIBuilder(url);
            // Post请求  
            HttpPost httppost = new HttpPost(builder.build());  
            // 设置参数  
            StringEntity stringEntity = new StringEntity(jsonString,"UTF-8");
//            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");//发送json数据需要设置contentType
            httppost.setEntity(stringEntity);  
            //设置报文头  
            httppost.setHeader("Accept", "application/json");
            httppost.setHeader("Content-type", "application/json");
            // 发送请求  
            HttpResponse httpresponse = httpClient.execute(httppost);
            return httpresponse;
            // 获取返回数据  
//            HttpEntity entity = httpresponse.getEntity();  
//            body = EntityUtils.toString(entity);  
//            if (entity != null) {  
//                EntityUtils.consume(entity);
//            }  
        } catch (Exception e) {  
            e.printStackTrace();  
        }
        return null;  
    }  
    
    public static HttpResponse postForm(String url, Map<String, String> params) {  
		HttpClient httpClient = HttpClientBuilder.create().build();
        try {  
            URIBuilder builder = new URIBuilder(url);
            // Post请求  
            HttpPost httppost = new HttpPost(builder.build());  
            // 设置参数  
            List<NameValuePair> nvps = new ArrayList <NameValuePair>();  
            
            Set<String> keySet = params.keySet();  
            for(String key : keySet) {  
                nvps.add(new BasicNameValuePair(key, params.get(key)));  
            }  
            httppost.setEntity(new UrlEncodedFormEntity(nvps));  
            //设置报文头  
//            httppost.setHeader("Accept", "application/json");
//            httppost.setHeader("Content-type", "application/json");
            // 发送请求  
            HttpResponse httpresponse = httpClient.execute(httppost);
            return httpresponse;
            // 获取返回数据  
//            HttpEntity entity = httpresponse.getEntity();  
//            body = EntityUtils.toString(entity);  
//            if (entity != null) {  
//                EntityUtils.consume(entity);
//            }  
        } catch (Exception e) {  
            e.printStackTrace();  
        }
        return null;  
    }  
}
