package com.ejianc.foundation.front.common.qqconnect;

import com.qq.connect.QQConnectException;
import com.qq.connect.javabeans.qzone.UserInfoBean;
import com.qq.connect.utils.json.JSONException;
import com.qq.connect.utils.json.JSONObject;

public class QQUserInfoBean extends UserInfoBean {
    private static final long serialVersionUID = -2841064553152585305L;
    private String qqAvatarURL40;//QQ小头像
    private String qqAvatarURL100;//QQ大头像
    private int sex;//0-男，1-女

    public QQUserInfoBean(JSONObject json) throws QQConnectException {
        super(json);
        if (json != null) {
            try {
                if (0 == this.getRet()) {
                    this.qqAvatarURL40 = json.getString("figureurl_qq_1");
                    this.qqAvatarURL100 = json.getString("figureurl_qq_2");
                    this.sex = "男".equals(this.getGender()) ? 0 : 1;
                }
            } catch (JSONException jsone) {
                throw new QQConnectException(jsone.getMessage() + ":" + json.toString(), jsone);
            }
        }
    }

    public String getQqAvatarURL40() {
        return qqAvatarURL40;
    }

    public String getQqAvatarURL100() {
        return qqAvatarURL100;
    }

    public int getSex() {
        return sex;
    }

}
