/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.ApplyJoinMessageBO;
import com.ejianc.foundation.front.business.ide.bo.ApplyJoinUserInfoBO;
import com.ejianc.foundation.front.business.ide.bo.UserMessageType;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeUserRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUserMessageService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdeUserMessageServiceImpl
implements IdeUserMessageService {
    @Autowired
    private IdeTeamRepo ideTeamRepo;
    @Autowired
    private IdeUserRepo ideUserRepo;

    @Override
    public List<ApplyJoinMessageBO> getApplyJoinMessage(String userId) {
        List<ApplyJoinMessageBO> applyJoinMessageList = this.ideTeamRepo.findApplyListByUserId(userId);
        if (!CollectionUtils.isEmpty(applyJoinMessageList)) {
            String teamIds = "";
            for (ApplyJoinMessageBO applyJoinMessageBO : applyJoinMessageList) {
                teamIds = teamIds + applyJoinMessageBO.getTeamId() + ",";
            }
            List<Map<String, Object>> results = this.ideUserRepo.findMapByTeamId(teamIds.substring(0, teamIds.length() - 1));
            if (!CollectionUtils.isEmpty(results)) {
                Map<String, List<Map>> teamUsersMap = results.stream().collect(Collectors.groupingBy(item -> (String)item.get("teamId")));
                applyJoinMessageList.forEach(applyJoinMessage -> {
                    if (teamUsersMap.containsKey(applyJoinMessage.getTeamId())) {
                        List teamUsers = (List)teamUsersMap.get(applyJoinMessage.getTeamId());
                        List<ApplyJoinUserInfoBO> userInfoList = teamUsers.stream().map(item -> {
                            ApplyJoinUserInfoBO userInfo = new ApplyJoinUserInfoBO();
                            userInfo.setUserId((String)item.get("userId"));
                            userInfo.setUserName((String)item.get("userName"));
                            userInfo.setUserCode((String)item.get("userCode"));
                            return userInfo;
                        }).collect(Collectors.toList());
                        applyJoinMessage.setUsers(userInfoList);
                    }
                });
            }
            return applyJoinMessageList.stream().filter(applyJoinMessage -> !CollectionUtils.isEmpty(applyJoinMessage.getUsers())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public JSONObject getUserMessage(String userId, UserMessageType[] messageTypes) {
        JSONObject result = new JSONObject();
        block4: for (UserMessageType messageType : messageTypes) {
            switch (messageType) {
                case APPLY_JOIN: {
                    result.put(UserMessageType.APPLY_JOIN.toString(), this.getApplyJoinMessage(userId));
                    continue block4;
                }
                case VERSION_UPDATE: {
                    result.put(UserMessageType.VERSION_UPDATE.toString(), null);
                    continue block4;
                }
            }
        }
        return result;
    }
}

