/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UiDefineToJsonUtil {
    public static JSONObject uiDefineToJson(final List<IdeUiDefine> data) {
        if (data != null && data.size() > 0) {
            final String allUiDefine = String.join((CharSequence)",", data.stream().map(IdeUiDefine::getCode).collect(Collectors.toList()));
            JSONObject backData = new JSONObject((Map)new HashMap<String, Object>(){
                {
                    HashMap<String, String> uiTypeDef = new HashMap<String, String>();
                    HashMap<String, String> uiTitleDef = new HashMap<String, String>();
                    HashMap<String, String> uiDefaultDef = new HashMap<String, String>();
                    HashMap<String, String> uiIconDef = new HashMap<String, String>();
                    HashMap<String, String> uiSubDef = new HashMap<String, String>();
                    for (IdeUiDefine uiDefine : data) {
                        uiTypeDef.put(uiDefine.getCode(), uiDefine.getParser());
                        uiTitleDef.put(uiDefine.getCode(), uiDefine.getName());
                        uiDefaultDef.put(uiDefine.getCode(), uiDefine.getDefaults());
                        uiIconDef.put(uiDefine.getCode(), uiDefine.getIcon());
                        if (uiDefine.getIncludeType().equals("part")) {
                            uiSubDef.put(uiDefine.getCode(), uiDefine.getIncludeContents());
                            continue;
                        }
                        if (!uiDefine.getIncludeType().equals("all")) continue;
                        uiSubDef.put(uiDefine.getCode(), allUiDefine);
                    }
                    this.put("UiTypeDef", uiTypeDef);
                    this.put("UiTitleDef", uiTitleDef);
                    this.put("UiDefaultDef", uiDefaultDef);
                    this.put("UiIconDef", uiIconDef);
                    this.put("UiSubDef", uiSubDef);
                }
            });
            return backData;
        }
        return null;
    }
}

