package com.ejianc.foundation.front.business.ide.controller;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeProductAppBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeAppOpenService;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 应用管理开放服务 提供给开发者开放平台使用
 * 
 * @author Dio.zhu
 */
@RestController
@RequestMapping(value = "/appopen")
public class IdeAppOpenController{
	@Autowired
	IdeAppOpenService ideAppOpenService;
	@Autowired
	IdeAppService ideAppService;
	@Autowired
	IdeAppGroupService ideAppGroupService;
	@Autowired
	IdeModuleService ideModuleService;

	@RequestMapping(value = "product/saveapp", method = RequestMethod.POST)
	public JsonBackData saveAppForProduct(@RequestBody IdeApp ideApp) {
		JsonBackData backData = new JsonBackData();
		try {
			ideAppOpenService.saveAppForProduct(ideApp);
			backData.setSuccess(true);
			backData.setBackMsg("保存成功");
		} catch (Exception e) {
			e.printStackTrace();
			backData.setSuccess(false);
			backData.setBackMsg(e.getMessage());
		}
		return backData;
	}

    @RequestMapping(value = "product/removeapp", method = RequestMethod.POST)
    public JsonBackData removeAppForProduct(@RequestParam String id) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppService.deleteById(id);
            backData.setBackMsg("删除成功");
        } catch (Exception e) {
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }

	@RequestMapping(value = "product/apps", method = RequestMethod.GET)
	public JsonBackData findProductApps(String productId) {
		JsonBackData backData = new JsonBackData();
		try {
			IdeProductAppBo productApps = ideAppOpenService.findAppByProduct(productId);
			backData.setBackData(productApps);
			backData.setBackMsg("查询成功");
		} catch (Exception e) {
			e.printStackTrace();
			backData.setBackMsg("系统错误");
			backData.setSuccess(false);
		}
		return backData;
	}
	
	@RequestMapping(value = "product/appcount", method = RequestMethod.GET)
	public JsonBackData findProductAppCount(String[] productIds) {
		JsonBackData backData = new JsonBackData();
		try {
			Object productAppCount = ideAppOpenService.findProductAppCount(Arrays.asList(productIds));
			backData.setBackData(productAppCount);
			backData.setBackMsg("查询成功");
		} catch (Exception e) {
			e.printStackTrace();
			backData.setBackMsg("系统错误");
			backData.setSuccess(false);
		}
		return backData;
	}
	
	/**
     * 保存文件夹
     * @return  {@link JsonBackData}
     */
    @RequestMapping(value="product/saveappgroup",method = RequestMethod.POST)
    public JsonBackData saveAppGroupForProduct(@RequestBody IdeAppGroup appGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(ideAppOpenService.saveAppGroupForProduct(appGroup));
            backData.setSuccess(true);
            backData.setBackMsg("保存成功");
        } catch (BusinessException e) {
        	backData.setSuccess(false);
        	backData.setBackMsg(e.getMessage());
		} catch (Exception e) {
            backData.setSuccess(false);
            backData.setBackMsg("保存文件夹异常");
        }
        return backData;
    }
    @RequestMapping(value = "product/removeappgroup", method = RequestMethod.POST)
    public JsonBackData removeAppGroupForProduct(@RequestParam String id) {
        JsonBackData backData = new JsonBackData();
        try {
            ideAppGroupService.deleteByIds(new String[]{id});
            backData.setBackMsg("删除成功");
        } catch (BusinessException e) {
            backData.setBackMsg(e.getMessage());
            backData.setSuccess(false);
        } catch (Exception e) {
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        }
        return backData;
    }
    
    @RequestMapping(value = "product/apppages", method = RequestMethod.GET)
	public JsonBackData findPageByProductApp(String appId) {
		JsonBackData backData = new JsonBackData();
		try {
			List<IdeModule> modules = ideAppOpenService.findPageByProductApp(appId);
			backData.setBackData(modules);
			backData.setBackMsg("查询成功");
		} catch (Exception e) {
			e.printStackTrace();
			backData.setBackMsg("系统错误");
			backData.setBackData(e.getMessage());
			backData.setSuccess(false);
		}
		return backData;
	}
    
    /**
     *  保存页面
     * @param ideModule
     * @return
     * @throws BusinessException
     * @throws Exception
     */
    @RequestMapping(value="product/saveapppage",method = RequestMethod.POST)
    public JsonBackData saveAppPageForProduct(@RequestBody IdeModule ideModule) throws BusinessException, Exception {
        try {
        	IdeModule module = ideModuleService.saveOrUpdate(ideModule);
            return JsonBackData.toSuccess("保存成功",module);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    /**
     * 删除页面
     * @param id
     * @return
     * @throws ServiceException
     * @throws Exception
     */
    @RequestMapping(value = "product/removeapppage", method = RequestMethod.POST)
    public JsonBackData removeAppPageForProduct(@RequestParam String id) throws Exception {
        try {
            ideModuleService.deleteById(id);
            return JsonBackData.toSuccess("删除成功");            
        } catch (Exception e) {
            e.printStackTrace();            
            return JsonBackData.toError(e.getMessage());
        }
    }
}
