package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentBO;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;


@Controller
@RequestMapping(value = "/ide/ideEnvironment")
public class IdeEnvironmentController {
	
	@Autowired
	private IdeEnvironmentService ideEnvironmentService;
	
	@SuppressWarnings("deprecation")
	@ResponseBody
	@RequestMapping(value = "showList" ,method = RequestMethod.POST)
	public JsonBackData showList(@RequestBody Map<String, Object> query) {
		JsonBackData back = new JsonBackData();
		int pageNumber = (Integer) query.get("pageNumber");
		int pageSize = (Integer) query.get("pageSize");
		try {
			Pageable pageable = null;
			pageable = new PageRequest(pageNumber <= 0 ? 0 :pageNumber, pageSize);
			back.setBackData(ideEnvironmentService.findAll(pageable));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "saveOrUpdate",method = RequestMethod.POST)
	public JsonBackData saveOrUpdate(@RequestBody IdeEnvironmentBO bo){
		JsonBackData back = new JsonBackData();
		try {
			ideEnvironmentService.saveOrUpdate(bo);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "delete",method = RequestMethod.POST)
	public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query){
		JsonBackData back = new JsonBackData();
		List<String> list = (List<String>) query.get("ids");
		String[] urls =  (String[])list.toArray(new String[list.size()]);
		try {
			ideEnvironmentService.deleteByUrls(urls);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
		@ResponseBody
		@RequestMapping(value = "findByUrl")
		public JsonBackData findByUrl(@RequestParam String url,@RequestParam int prodType) {
			JsonBackData back = new JsonBackData();
			try {
				back.setBackData(ideEnvironmentService.findByUrl(url,prodType));
			} catch (BusinessException ex) {
				back.setSuccess(false);
				back.setBackMsg(ex.getMessage());
			} catch (Exception ex) {
				ex.printStackTrace();
				back.setSuccess(false);
				back.setBackMsg("获取数据失败！");
			}
			return back;
		}
		
		@ResponseBody
		@RequestMapping(value = "findAllUrls")
		public JsonBackData findAllUrls() {
			JsonBackData back = new JsonBackData();
			try {
				back.setBackData(ideEnvironmentService.findAllUrls());
			}  catch (Exception e) {
				e.printStackTrace();
				back.setSuccess(false);
				back.setBackMsg("查询列表数据失败！");
			}
			return back;
		}

}
