package com.ejianc.foundation.front.business.ide.controller;

import javax.validation.Valid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeUiLibraryBO;
import com.ejianc.foundation.front.business.ide.service.IdeUiLibraryService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * @author andy
 */
@RequestMapping(value = "ide/uiLibrary")
@RestController
public class IdeUiLibraryController {
    private static final Logger logger = LoggerFactory.getLogger(IdeUiLibraryController.class);

    @Autowired
    private IdeUiLibraryService service;

    @RequestMapping(value = "create", method = RequestMethod.POST)
    public JsonBackData create(@Valid @RequestBody IdeUiLibraryBO library) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(service.create(library));
        } catch (Exception e) {
            logger.error("创建库异常！", e);
            back.setSuccess(false);
            back.setBackMsg("创建库异常！");
        }
        return back;
    }

    @RequestMapping(value = "update", method = RequestMethod.POST)
    public JsonBackData update(@Valid @RequestBody IdeUiLibraryBO library) {
        JsonBackData back = new JsonBackData();
        try {
            service.update(library);
        } catch (Exception e) {
            logger.error("修改库异常！", e);
            back.setSuccess(false);
            back.setBackMsg("修改库异常！");
        }
        return back;
    }

    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public JsonBackData delete(@RequestParam String id) {
        JsonBackData back = new JsonBackData();
        try {
            service.delete(id);
        } catch (Exception e) {
            logger.error("删除库异常！", e);
            back.setSuccess(false);
            back.setBackMsg("删除库异常！");
        }
        return back;
    }

    @RequestMapping(value = "queryList", method = RequestMethod.GET)
    public JsonBackData queryList() {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(service.queryList());
        } catch (Exception e) {
            logger.error("查询库列表异常！", e);
            back.setSuccess(false);
            back.setBackMsg("查询库列表异常！");
        }
        return back;
    }

    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    public JsonBackData queryDetail(String id, String searchText) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(service.queryDetail(id, searchText));
        } catch (Exception e) {
            logger.error("查询库详情异常！", e);
            back.setSuccess(false);
            back.setBackMsg("查询库详情异常！");
        }
        return back;
    }
}
