package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;

/**
 * 模块数据模型service
 */
public interface IdeResourceService {

    /**
     * 保存数据模型
     *
     * @param resource 数据模型
     * @return 数据模型
     */
    IdeResource save(IdeResource resource);

    /** 
     * 获取数据模型
     *
     * @param id 主键
     * @return 数据模型
     */
    IdeResource findById(String id);

    /**
     * 删除数据模型
     *
     * @param id 主键
     */
    void deleteById(String id);

    /**
     * 获取数据模型列表
     *
     * @param appId 应用id
     * @return 数据模型列表
     */
    List<IdeResource> findByAppId(String appId);

    /**
     * 更改资源名称
     *
     * @param createId 用户id
     * @param id 主键
     * @param name 资源名
     * @param version 版本号
     * @return 数据模型
     */
    IdeResource updateName(String createId, String id, String name, int version);

    /**
     * 更改资源数据
     *
     * @param createId 用户id
     * @param id 主键
     * @param data 资源数据
     * @param version 版本号
     * @return 数据模型
     */
    IdeResource updateData(String createId, String id, String data, int version);
    
    /**
     * 通过应用编码和资源编码获取资源数据
     * @param appCode
     * @param resourceCode
     * @return
     */
    IdeResource findByAppCodeAndResourceCode(String appCode, String resourceCode);
}
