package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import com.ejianc.foundation.front.business.ide.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.entity.JoinStatus;
import com.ejianc.foundation.front.business.ide.entity.RoleType;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdePartWidgetRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Service
@Transactional
public class IdeAppServiceImpl implements IdeAppService {

    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdePartWidgetRepo idePartWidgetRepo;
    @Autowired
    IdeTeamService ideTeamService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeTeamRepo teamRepo;
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    IdeAppGroupRepo ideAppGroupRepo;
    @Autowired
    IdeCommonService ideCommonService;
	@Autowired
	IdeAppGroupService ideAppGroupService;

    @Override
    public void saveOrUpdate(IdeApp ideApp) throws BusinessException, Exception {
        if (StringUtils.isEmpty(ideApp.getName())) {
            throw new BusinessException("应用名称不能为空");
        }
        IdeTeam team = null;
        if(ideApp.getTeamId()!=null){
	        team = teamRepo.findOne(String.valueOf(ideApp.getTeamId()));
	        if(team==null){
	        	throw new BusinessException("团队不存在或已删除");
	        }
        }
        if (ideApp.getId() != null && ideApp.getId() > 0) {//修改
			IdeApp ideAppEntity = ideAppRepo.findById(String.valueOf(ideApp.getId()));
			ideAppEntity.setModifyDate(new Date());
			ideAppEntity.setModifyId(InvocationInfoProxy.getUserid());
			ideAppEntity.setName(ideApp.getName());
			ideAppEntity.setBillTypeCode(ideApp.getBillTypeCode());
			ideAppEntity.setBillTypeName(ideApp.getBillTypeName());
			ideAppEntity.setGroupId(ideApp.getGroupId());
			ideAppEntity.setTechnicalType(ideApp.getTechnicalType());
			ideAppEntity.setIpAddress(ideApp.getIpAddress());
			ideAppRepo.update(ideAppEntity);
        } else {//新增
			List<IdeApp> ideAppList = ideAppRepo.findNameInTeam(ideApp.getName(), String.valueOf(ideApp.getTeamId()));
			if (ideAppList.size()>0){
				throw new BusinessException("团队中已存在相同的应用名称");
			}else {
				ideApp.setId(IdWorker.getId());
				// 获取单据编号
				if(StringUtils.isEmpty(ideApp.getCode())){
					String code = ideCommonService.generateAppCode();
					ideApp.setCode(code);
				}
				ideApp.setCreateDate(new Date());
				ideAppRepo.save(ideApp);
			}
        }
        if(team!=null){//更新团队应用数
            this.updateTeamAppCount(team);
        }
    }
    
    @Override
    public List<IdeApp> findByCreateId(String createId,String clientType) throws BusinessException {
        return ideAppRepo.findByCreateId(createId, clientType);
    }
    @Override
    public void updateOpen(String appId, int open, String createId){
    	IdeApp ideApp = ideAppRepo.findById(appId);
    	if (ideApp==null) {
			throw new BusinessException("应用不存在或已被删除");
    	}
		ideApp.setIsOpen(open);
		ideApp.setModifyDate(new Date());
		ideApp.setModifyId(Long.parseLong(createId));
		ideAppRepo.update(ideApp);
    }
    @Override
    public List<IdeTeamBo>  findTeamAppsByUser(String createId, int prodType, String clientType) {
    	//我的团队应用列表
    	List<IdeTeamBo> myTeamApps = new ArrayList<>();
    	//未归团的应用
    	List<IdeApp> noteamApps = ideAppRepo.findNoTeamApps(createId, clientType);
    	if(noteamApps!=null&&noteamApps.size()>0){
    		IdeTeamBo noteam = new IdeTeamBo();
    		noteam.setCode("NOTEAM");
    		noteam.setName("未归团");
    		noteam.setCreateId(createId);
    		noteam.setJoinStatus(JoinStatus.IN.getValue());
    		noteam.setRoleType(RoleType.SUPER_ADMIN.getValue());
    		noteam.setMemberCount(1);
    		noteam.setAppCount(noteamApps.size());
    		noteam.setApps(noteamApps);
    		myTeamApps.add(noteam);
    	}
    	//获取用户加入的团队列表
    	List<IdeTeamBo> userTeams = ideTeamService.queryUserTeams(createId, prodType);
    	if(userTeams==null||userTeams.size()==0){
    		return myTeamApps;
    	}else{
    		myTeamApps.addAll(userTeams);
    	}
    	String teamIds = "";
    	for(int i=0;i<userTeams.size();i++){
    		teamIds += userTeams.get(i).getId() + ",";
    	}
    	if(teamIds.length()>0){
			teamIds = teamIds.substring(0, teamIds.length()-1);
		}
    	//获取团队对应的应用列表
    	List<IdeApp> teamApps = ideAppRepo.findTeamApps(teamIds, clientType);
    	//建立各团队对应的应用列表关系
    	Map<Long,List<IdeApp>> mapper = new HashMap<>();
    	for(int i=0;i<teamApps.size();i++){
    		IdeApp app = teamApps.get(i);
    		if(app.getGroupId() == null) {
    			List<IdeApp> appList = mapper.get(app.getTeamId());
        		if(appList==null){
        			appList = new ArrayList<>();
        		}
        		appList.add(app);
        		mapper.put(app.getTeamId(), appList);
    		}
    	}
    	//获取团队对应的应用模块
    	List<IdeAppGroup> appGroups = ideAppGroupService.findByTeamIds(teamIds, clientType);
    	Map<String,List<IdeAppGroup>> appGroupMap = new HashMap<>();
    	if(appGroups!=null&&appGroups.size()>0){
    		for (IdeAppGroup appGroup : appGroups) {
        		List<IdeAppGroup> appGroupList = appGroupMap.get(appGroup.getTeamId());
        		if(appGroupList==null){
        			appGroupList = new ArrayList<IdeAppGroup>();
        		}
        		appGroupList.add(appGroup);
        		appGroupMap.put(String.valueOf(appGroup.getTeamId()), appGroupList);
    		}
    	}
    	for(int i=0;i<userTeams.size();i++){
    		IdeTeamBo team = userTeams.get(i);
    		team.setApps(mapper.get(Long.parseLong(team.getId())));
    		team.setGroups(appGroupMap.get(team.getId()));
    	}
    	return myTeamApps;
    }
    @Override
    public List<IdeTeamBo>  findTeamPublicApps(String createId, int prodType,String clientType) {
    	//获取用户加入的团队列表
    	List<IdeTeamBo> joinTeams = ideTeamService.queryUserTeams(createId, prodType);
    	if(joinTeams==null)joinTeams = new ArrayList<IdeTeamBo>();
    	//获取团队对应的应用列表
    	String joinTeamIds = "";
    	for(int i=0;i<joinTeams.size();i++){
    		joinTeamIds += joinTeams.get(i).getId() + ",";
    	}
    	if(StringUtils.isBlank(joinTeamIds)){
    		joinTeamIds = "-1";
    	}else{
    		joinTeamIds = joinTeamIds.substring(0, joinTeamIds.length()-1);
    	}
    	//获取非加入团队的公开应用列表
    	List<IdeApp> teamApps = ideAppRepo.findPublicApps(prodType, joinTeamIds, clientType);
    	//建立各团队对应的应用列表关系
    	Map<String,List<IdeApp>> mapper = new HashMap<String,List<IdeApp>>();
    	String teamIds = "";
    	for(int i=0;i<teamApps.size();i++){
    		IdeApp app = teamApps.get(i);
    		List<IdeApp> appList = mapper.get(app.getTeamId());
    		if(appList==null){
    			appList = new ArrayList<IdeApp>();
    		}
    		appList.add(app);
    		mapper.put(String.valueOf(app.getTeamId()), appList);
    		
    		teamIds += String.valueOf(app.getTeamId()) + ",";
    	}
    	//获取当前用户未加入的团队信息
    	List<IdeTeam> nojoinTeams = mapper.keySet().size()>0?teamRepo.findAll(teamIds.substring(0, teamIds.length()-1)):new ArrayList<IdeTeam>();
    	List<IdeTeamBo> nojoinTeamPublisApps = new ArrayList<IdeTeamBo>();
    	for(int i=0;i<nojoinTeams.size();i++){
    		IdeTeamBo team = new IdeTeamBo(nojoinTeams.get(i));
    		team.setApps(mapper.get(team.getId()));
    		nojoinTeamPublisApps.add(team);
    	}
    	 return nojoinTeamPublisApps;

    }
    
    @Override
    public List<IdeApp> findNoTeamApps(String createId,String clientType){
        return ideAppRepo.findNoTeamApps(createId,clientType);
    }

    public List<IdeApp> findAll(String clientType) throws BusinessException, Exception {
    	List<IdeApp> ideApps = ideAppRepo.findAll(clientType);
        List<IdeModule> sysModules = ideModuleRepo.findAll(clientType);

        for (int i=0;i<ideApps.size();i++) {
            List<IdeModule> appChildren = new ArrayList<IdeModule>();
            for (IdeModule module : sysModules) {
            	if (module.getAppId() != null && module.getAppId() > 0) {
            		continue;
            	}
                if (module.getAppId().equals(ideApps.get(i).getId())) {
                    module.setAppCode(ideApps.get(i).getCode());
                    appChildren.add(module);
                }
            }
            if (appChildren.size()>0) {
                ideApps.get(i).setChildren(appChildren);
            }

        }
        return ideApps;

    }

    @Override
    public void deleteById(String id) throws BusinessException, Exception {
    	// 标记删除应用
    	IdeApp app = ideAppRepo.findById(id);
    	app.setIsDelete(1);
    	ideAppRepo.deleteById(id);
    	// 删除应用下的页面
        List<IdeModule> pageList = ideModuleRepo.findByAppId(id);
        List<String> idList = new ArrayList<>();
        List<String> codeList = new ArrayList<>();
        
        String ids = "";
        for (IdeModule page: pageList) {
        	ids += page.getId() + ",";
            idList.add(String.valueOf(page.getId()));
            codeList.add(page.getCode());
        }
        if (idList.size()>0) {
            ideModuleRepo.deleteByIds(ids.substring(0, ids.length()-1));
            ideModulePrivateRepo.deleteByModuleIds(ids.substring(0, ids.length()-1));
        }
        //更新团队下的应用个数
        if(app.getTeamId()!=null){
	        IdeTeam team = teamRepo.findOne(String.valueOf(app.getTeamId()));
	        if(team!=null){
	        	this.updateTeamAppCount(team);
	        }
        }

    }

    @Override
    public void copyApp(IdeApp ideApp) throws Exception {
    	IdeApp ideAppSrc = ideAppRepo.findById(String.valueOf(ideApp.getId()));
        if(ideAppSrc==null){
         	throw new BusinessException("应用不存在或已删除");
        }
        Date nowDate = new Date();
        List<IdeModule> ideModuleList = ideModuleRepo.findByAppId(String.valueOf(ideApp.getId()));
        //复制后的新应用
        IdeApp ideAppSave = new IdeApp();
        ideAppSave.setId(IdWorker.getId());
        ideAppSave.setName(ideApp.getName());
        ideAppSave.setTeamId(ideApp.getTeamId());
        ideAppSave.setCreateId(ideApp.getCreateId());
        ideAppSave.setCreateDate(nowDate);
        ideAppSave.setBillTypeCode(ideApp.getBillTypeCode());
        ideAppSave.setBillTypeName(ideApp.getBillTypeName());
        if(ideAppSrc.getTeamId()!=null&&ideAppSrc.getTeamId().equals(ideApp.getTeamId())){
        	ideAppSave.setGroupId(ideAppSrc.getGroupId());//源团队与目标团队相同时则复制到相同的应用分组
        }
        // 生成新的应用编码
		String code = ideCommonService.generateAppCode();
        ideAppSave.setCode(code);
        ideAppSave.setIsOpen(0);// 复制后默认为非公开应用
        ideAppRepo.save(ideAppSave);
        //复制应用下的页面
        if(ideModuleList!=null&&ideModuleList.size()>0){
            String[] newPageCodes = ideCommonService.generateModuleCodes(ideModuleList.size());
            for(int i=0;i<ideModuleList.size();i++){
            	IdeModule moduleSrc = ideModuleList.get(i);
                IdeModule moduleSave = new IdeModule();
                BeanUtils.copyProperties(moduleSrc, moduleSave, new String[]{"id","code","createId", "createDate"});
                moduleSave.setId(IdWorker.getId());
                // 生成新的页面编码
                moduleSave.setCode(newPageCodes[i]);
                moduleSave.setAppId(ideAppSave.getId());
                moduleSave.setCreateId(ideApp.getCreateId());
                moduleSave.setCreateDate(nowDate);
                moduleSave.setFromId(moduleSrc.getId());
                moduleSave.setFromName(moduleSrc.getName());
                ideModuleRepo.save(moduleSave);
            }
            
        }
        //更新源团队下的应用个数
        if(ideAppSrc.getTeamId()!=null){
	        IdeTeam sourceTeam = teamRepo.findOne(String.valueOf(ideAppSrc.getTeamId()));
	        if(sourceTeam!=null){
	        	this.updateTeamAppCount(sourceTeam);
	        }
        }
        //更新目标团队下的应用个数
        if(ideApp.getTeamId()!=null){
	        IdeTeam targetTeam = teamRepo.findOne(String.valueOf(ideApp.getTeamId()));
	        if(targetTeam!=null){
	        	this.updateTeamAppCount(targetTeam);
	        }
        }
    }

	@Override
	public IdeApp findById(String id) throws BusinessException {
		return ideAppRepo.findById(id);
	}

	@Override
	public IdeApp findByCode(String code) throws BusinessException {
		List<IdeApp> apps = ideAppRepo.findAllByCode(code);
		if(apps!=null&&apps.size()>0){
			return apps.get(0);
		}else{
			return null;
		}
	}

	@Override
	public List<IdeApp> findAllApps(boolean isDelete, String clientType) throws BusinessException{
		return ideAppRepo.findAllApps(clientType);
	}

	@Override
	public void removeById(String id) throws Exception {
		List<IdeTeam> ideTeams = teamRepo.findTeamByAppIds(id);
		List<String> moduleIds = ideModuleRepo.findModuleIdsByAppId(id);
		if(moduleIds!=null&&moduleIds.size()>0){
			String moduleIdStr = "";
			 for(int i=0;i<moduleIds.size();i++){
				 moduleIdStr += moduleIds.get(i) + ",";
			 }
			ideModuleRepo.removeByIds(moduleIdStr.substring(0, moduleIdStr.length()-1));
		}
		ideAppRepo.deleteById(id);
		if (ideTeams != null && ideTeams.size() > 0) {
			for (IdeTeam ideTeam : ideTeams) {
				ideTeam.setAppCount(teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
				teamRepo.update(ideTeam);
			}
		}

	}

	@Override
	public void recoverById(String id) throws Exception {
		ideAppRepo.recoverById(id);
	}

    /**
     * 绑定应用其所属的团队
     *
     * @param teamId 团队id
     * @param appIds 应用id数组
     */
    @Transactional
    @Override
    public void bindTeamOfApps(String teamId, String[] appIds,String groupId) {
    	IdeTeam team = teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("团队不存在或已删除，团队id: %s", teamId));
        }
        List<IdeApp> apps = new ArrayList<>();
        String appIdStr = "";
        if(appIds != null && appIds.length > 0) {
        	for(String appId:appIds) {
        		appIdStr += appId + ",";
        	}
        	apps = ideAppRepo.findAllByIds(appIdStr.substring(0, appIdStr.length()-1));
        }
        if (CollectionUtils.isEmpty(apps)) {
            throw new BusinessException(String.format("不存在id属于(%s)的应用", appIdStr));
        } else {
            apps.forEach(new Consumer<IdeApp>(){
				@Override
				public void accept(IdeApp app) {
					app.setTeamId(team.getId());
					app.setGroupId(Long.parseLong(groupId));
					ideAppRepo.update(app);
				}
            });
            //更新团队应用数
            this.updateTeamAppCount(team);
        }

    }

	@Override
	public void updateTeamAppCount(IdeTeam team) {
		if(team!=null){
			 //更新团队应用数
		    int appsNum = ideAppRepo.countApps(String.valueOf(team.getId()));
		    team.setAppCount(appsNum);
		    teamRepo.update(team);
		}

	}

	

	@Override
	public List<IdeApp> findAppTeamId(String teamId) throws BusinessException, Exception {
		return ideAppRepo.findAppByTeamId(teamId);
	}

	@Override
	public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
		if (ids != null && ids.size()>0) {
			String idStr = "";
			for(String id:ids) {
				idStr += id + ",";
			}
			List<IdeModulePrivate> modulePrivates = ideModulePrivateRepo.findListByAppIds(idStr.substring(0, idStr.length()-1));
			return modulePrivates;
		}
		return null;

	}
	
	@Override
	public void deleteByIds(List<String> ids,boolean isRemove) throws BusinessException, Exception {
		List<IdeModule> ideModules = ideModuleService.findInAppIds(ids.toArray(new String[ids.size()]));
		if (isRemove) {
			if (ideModules != null && ideModules.size()>0) {
				String moduleIds = "";
				for (IdeModule ideModule : ideModules) {
					moduleIds += ideModule.getId() + ",";
				}
				ideModuleRepo.removeByIds(moduleIds.substring(0, moduleIds.length()-1));
				ideModulePrivateRepo.removeByModuleIds(moduleIds.substring(0, moduleIds.length()-1));
			}
			String idStr = "";
			if(ids != null && ids.size() > 0) {
				for(String id:ids) {
					idStr += id + ",";
				}
				ideAppRepo.removeByIds(idStr.substring(0, idStr.length()-1));
			}
		}else {	
			String idStr = "";
			if(ids != null && ids.size() > 0) {
				for(String id:ids) {
					idStr += id + ",";
				}
			}
			List<IdeTeam> ideTeams = teamRepo.findTeamByAppIds(idStr.substring(0, idStr.length()-1));
			if (ideModules != null && ideModules.size()>0) {
				String moduleIds = "";
				for (IdeModule ideModule : ideModules) {
					moduleIds += ideModule.getId() + ",";
				}
				ideModuleRepo.deleteByIds(moduleIds.substring(0, moduleIds.length()-1));
	            moduleDataRepo.deleteByModuleIds(moduleIds.substring(0, moduleIds.length()-1));
	            ideModulePrivateRepo.deleteByModuleIds(moduleIds.substring(0, moduleIds.length()-1));
			}
			String idStrs = "";
			if(ids != null && ids.size() > 0) {
				for(String id:ids) {
					idStrs += id + ",";
				}
				ideAppRepo.deleteByIds(idStrs.substring(0, idStrs.length()-1));
			}
			if (ideTeams != null && ideTeams.size() > 0) {
				for (IdeTeam ideTeam : ideTeams) {
					ideTeam.setAppCount(teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
					teamRepo.update(ideTeam);
				}
			}
		}
	}

	@Override
	public void recoverByIds(List<String> ids) throws BusinessException, Exception {
		String idStr = "";
		for(String id:ids) {
			idStr += id + ",";
		}
		if(StringUtils.isNotBlank(idStr)) {
			idStr = idStr.substring(0, idStr.length() - 1);
		}
		ideAppRepo.recoverByIds(idStr);
		ideModuleRepo.recoverByAppIds(idStr);
		ideModulePrivateRepo.recoverByAppIds(idStr);
		List<IdeTeam> ideTeams = teamRepo.findTeamByAppIds(idStr);
		if (ideTeams != null && ideTeams.size() > 0) {
			for (IdeTeam ideTeam : ideTeams) {
				ideTeam.setAppCount(teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
				
				teamRepo.save(ideTeam);
			}
		}	
	}

	@Override
	public Page<IdeApp>  findPage(String teamId, String searchText, boolean isDelete, Pageable pageable) throws BusinessException, Exception {
		Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
		List<IdeApp> list = ideAppRepo.findAppListByTeamId(teamId,searchText,isDelete,pageIndex,pageable.getPageSize());
		long total = ideAppRepo.findModuleCountByTeamId(teamId,searchText,isDelete);
		Page<IdeApp> page = new PageImpl<>(list,pageable,total);
		return page;
	}


}
