package com.ejianc.foundation.front.business.ide.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.service.SqlExportService;

@Controller
@RequestMapping(value = "ide/sqlExport")
public class IdeSqlExportController {
	
	@Autowired
	private SqlExportService sqlExportService;
	
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeSqlExportController.class);
	
	/**
	 * 抽取sql脚本
	 * @param req		http头信息
	 * @param typeCode	自定义档案类型code
	 * @param def1		自定义档案扩展字段def1
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(
			HttpServletRequest req,
			HttpServletResponse response,
			@RequestBody(required = false) Map<String, Object> paras
			) {
		try {
			List<String> appCodes = (List<String>) paras.get("appCodes");
			List<String> teamCodes = (List<String>) paras.get("teamCodes");
			List<String> result = sqlExportService.exportSql(req,appCodes,teamCodes);
			StringBuffer fileName = new StringBuffer();
			String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
			fileName.append(date);
			fileName.append(".sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			//将sql结果list转换为string并换行
			out.write(String.join("\r\n",result).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
           LOGGER.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}

	}
}
