package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdeTeamDatasource;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamDatasourceRepo;
import com.ejianc.foundation.front.business.ide.service.IdeTeamDatasourceService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Transactional(readOnly = true)
@Service
public class IdeTeamDatasourceServiceImpl implements IdeTeamDatasourceService {
    @Autowired
    private IdeTeamDatasourceRepo datasourceRepo;

    @Transactional
    @Override
    public List<IdeTeamDatasource> updateTeamDatasource(String teamId, String[] datasourceCodes) {
    	if(datasourceCodes != null && datasourceCodes.length > 0) {
    		for(String datasourceCode:datasourceCodes) {
    			IdeTeamDatasource datasource = new IdeTeamDatasource();
    			datasource.setId(IdWorker.getId());
    			datasource.setCode(String.valueOf(IdWorker.getId()));
    			datasource.setCreateDate(new Date());
    			datasource.setTeamId(Long.parseLong(teamId));
    			datasource.setSourceCode(datasourceCode);
    			datasourceRepo.save(datasource);
    		}
    	}
        datasourceRepo.deleteByTeamId(teamId);
        
        return null;
    }

    @Transactional
    @Override
    public void deleteById(String id) {
        IdeTeamDatasource datasource = datasourceRepo.findOne(id);
        if (datasource == null) {
            throw new BusinessException("该团队数据源不存在或已被删除!");
        }
        datasourceRepo.logicDel(datasource.getId());
    }

    @Transactional
    @Override
    public void deleteByIds(String[] ids) {
        Arrays.stream(ids).forEach(this::deleteById);
    }

    @Override
    public IdeTeamDatasource findById(String id) {
        return datasourceRepo.findOne(id);
    }

    @Override
    public List<IdeTeamDatasource> findByTeamId(String teamId) {
        return datasourceRepo.findByTeamId(teamId);
    }
}
