package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivateVerifyHis;

@Mapper
public interface IdeModulePrivateRepo {
	
	List<IdeModulePrivate> findByCodeAndOrgId(@Param("code") String code,@Param("orgId") String orgId);
	
	IdeModulePrivate findById(@Param("id") String id);

	List<IdeModulePrivate> findByIds(@Param("ids") String ids);
    
    void deleteByIds(@Param("ids") String ids);
	
	//根据页面id删除
    void deleteByModuleIds(@Param("moduleIds") String moduleIds);
	
	//根据页面id彻底删除
    void removeByModuleIds(@Param("moduleIds") String moduleIds);
	
	//根据页面id恢复
	void recoverByModuleIds(@Param("moduleIds") String moduleIds);
	
	//根据应用id恢复
	void recoverByAppIds(@Param("appIds") String appIds);
	//根据组织，应用编码，页面编码查询当前组织实例
	IdeModulePrivate findByOrgId(@Param("appCode") String appCode,@Param("pageCode") String pageCode,@Param("orgId") String orgId);
	
	//查询父级组织所有向下兼容的实例
	List<IdeModulePrivate> findByOrgIds(@Param("appCode") String appCode,@Param("pageCode") String pageCode,@Param("orgIds") String orgIds);

	List<IdeModulePrivate> findListByAppIds(@Param("appIds") String appIds);

	List<IdeModulePrivate> findListByModuleIds(@Param("moduleIds") String moduleIds);

	void save(IdeModulePrivate ideModulePrivate);

	void update(IdeModulePrivate newModulePrivate);

	List<IdeModulePrivateVerifyHis> queryVerifyHistoryList(@Param("code") String code,@Param("orgIdStrs") String orgIdStrs,@Param("appId") String appId,
			@Param("condition") String condition,@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

	Long queryVerifyHistoryCount(@Param("code") String code,@Param("orgIdStrs") String orgIdStrs,@Param("appId") String appId,
			@Param("condition") String condition);

	void updateAttachVerify(@Param("modifyId") String modifyId,@Param("idStr") String idStr);

	List<IdeModulePrivate> queryUnverifyList(@Param("code") String code,@Param("orgIdStrs") String orgIdStrs,@Param("appId") String appId,@Param("condition") String condition,
			@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

	Long queryUnverifyCount(@Param("code") String code,@Param("orgIdStrs") String orgIdStrs,@Param("appId") String appId,@Param("condition") String condition);

	List<IdeModulePrivate> queryModulePrivateList(@Param("orgIdStrs") String orgIdStrs,@Param("code") String code,@Param("appId") String appId,@Param("pageIndex") Integer pageIndex,
			@Param("pageSize") Integer pageSize);

	Long queryModulePrivateCount(@Param("orgIdStrs") String orgIdStrs,@Param("code") String code,@Param("appId") String appId);
}
