package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.ejianc.foundation.front.business.ide.bo.IdeUiLibraryBO;

/**
 * @author andy
 */
public interface IdeUiLibraryService {

    /**
     * 创建库
     *
     * @param library 库
     * @return 库id
     */
    String create(IdeUiLibraryBO library);

    /**
     * 更新库
     *
     * @param library 库
     */ 
    void update(IdeUiLibraryBO library);

    /**
     * 删除库
     *
     * @param id id
     */
    void delete(String id);

    /**
     * 查询库列表
     *
     * @return 库列表
     */
    List<IdeUiLibraryBO> queryList();

    /**
     * 查询库详情
     *
     * @param id id
     * @param searchText 模糊匹配文本
     * @return 库详情
     */
    IdeUiLibraryBO queryDetail(String id, String searchText);
}
