package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.ejianc.foundation.front.business.ide.bo.IdeProductAppBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppOpenRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppOpenService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 提供给开发者开放平台使用
 * 
 * @author Dio.zhu
 *
 */
@Service
@Transactional
public class IdeAppOpenServiceImpl implements IdeAppOpenService {
	@Autowired
	IdeAppRepo ideAppRepo;
	@Autowired
	IdeAppGroupRepo ideAppGroupRepo;
	@Autowired
	IdeAppOpenRepo ideAppOpenRepo;
	@Autowired
	IdeModuleRepo ideModuleRepo;
	@Autowired
	IdeCommonService ideCommonService;

	@Override
	public void saveAppForProduct(IdeApp ideApp) throws BusinessException, Exception {
		if (StringUtils.isEmpty(ideApp.getName())) {
			throw new BusinessException("应用名称不能为空");
		}
		if (StringUtils.isEmpty(ideApp.getProductId())) {
			throw new BusinessException("所属项目不能为空");
		}
		if (StringUtils.isEmpty(ideApp.getCreateId())) {
			throw new BusinessException("创建人不能为空");
		}

		if (StringUtils.isEmpty(ideApp.getId())) {// 新增
			Long hasCount = ideAppOpenRepo.countNameInProduct(ideApp.getName(), String.valueOf(ideApp.getProductId()));
			if (hasCount != null && hasCount > 0) {
				throw new BusinessException("项目中已存在相同的应用名称");
			} else {
				// 生成单据编号
				ideApp.setId(IdWorker.getId());
				if (StringUtils.isEmpty(ideApp.getCode())) {
					String code = ideCommonService.generateAppCode();
					ideApp.setCode(code);
				}
				ideApp.setCreateDate(new Date());
				ideAppRepo.save(ideApp);
			}
		}else{//更新
			 IdeApp ideAppEntity = ideAppRepo.findById(String.valueOf(ideApp.getId()));
	         ideAppEntity.setModifyDate(new Date());
	         ideAppEntity.setName(ideApp.getName());//名称
	         ideAppEntity.setGroupId(ideApp.getGroupId());//所属分组
	         ideAppRepo.update(ideAppEntity);
		}
	}

	@Override
	public IdeProductAppBo findAppByProduct(String productId) throws BusinessException {
		IdeProductAppBo productAppBo = new IdeProductAppBo();
		if (StringUtils.isEmpty(productId)) {
			throw new BusinessException("所属项目不能为空");
		}
		//获取项目下全部应用
		List<IdeApp> apps = ideAppOpenRepo.findProductApps(productId);
		//获取项目下全部分组
		List<IdeAppGroup> appGroups = ideAppOpenRepo.findProductAppGroups(productId);
		List<IdeApp> noGroupApps = new ArrayList<>();//无分组的应用
		Map<String,List<IdeApp>> groupMapApps = new HashMap<>();
		//将应用按分组进行归类整理
		apps.forEach(new Consumer<IdeApp>() {
			public void accept(IdeApp app) {
				if(StringUtils.isEmpty(app.getGroupId())){//无分组
					noGroupApps.add(app);
				}else{//有分组
					List<IdeApp> applist = groupMapApps.get(app.getGroupId());
					if(applist==null)applist=new ArrayList<IdeApp>();
					applist.add(app);
					groupMapApps.put(String.valueOf(app.getGroupId()), applist);
				}
			};
		});
		appGroups.forEach(new Consumer<IdeAppGroup>() {
			public void accept(IdeAppGroup appGroup) {
				appGroup.setApps(groupMapApps.get(appGroup.getId()));
			}
		});
		productAppBo.setAppCount(apps.size());
		productAppBo.setApps(noGroupApps);
		productAppBo.setGroups(appGroups);
		return productAppBo;
	}

	@Override
	public IdeAppGroup saveAppGroupForProduct(IdeAppGroup appGroup) throws BusinessException {
		if (StringUtils.isEmpty(appGroup.getName())) {
			throw new BusinessException("名称不能为空");
		}
		if (StringUtils.isEmpty(appGroup.getProductId())) {
			throw new BusinessException("所属项目不能为空");
		}
		if (StringUtils.isEmpty(appGroup.getCreateId())) {
			throw new BusinessException("创建人不能为空");
		}

		IdeAppGroup ideAppGroup = ideAppOpenRepo.findAppGroupByProductIdAndName(appGroup.getName(), String.valueOf(appGroup.getProductId()));
		if (StringUtils.isEmpty(appGroup.getId())) {// 创建组
			if (ideAppGroup != null) {
				throw new BusinessException("同一个项目下不能有相同的文件夹名！");
			}
			String appGroupCode = ideCommonService.generateAppGroupCode();
			appGroup.setId(IdWorker.getId());
			appGroup.setCode(appGroupCode);
			appGroup.setCreateDate(new Date());
			ideAppGroupRepo.save(appGroup);
		} else {// 修改组
			if (ideAppGroup != null && !ideAppGroup.getName().equals(appGroup.getName())) {
				throw new BusinessException("同一个项目下不能有相同的文件夹名！");
			}
			IdeAppGroup oldAppGroup = ideAppGroupRepo.findOne(String.valueOf(appGroup.getId()));
			oldAppGroup.setName(appGroup.getName());
			oldAppGroup.setModifyDate(new Date());
			appGroup = ideAppGroupRepo.update(oldAppGroup);
		}

		return appGroup;
	}

	@Override
	public List<IdeModule> findPageByProductApp(String appId) throws BusinessException {
		List<IdeModule> beans = ideModuleRepo.findByAppId(appId);
		return beans;
	}

	@Override
	public Map<String, Integer> findProductAppCount(List<String> productIds) {
		String productIdStr = "";
		if(productIds != null && productIds.size() > 0) {
			for(String productId:productIds) {
				productIdStr += productId + ",";
			}
			productIdStr = productIdStr.substring(0, productIdStr.length() - 1);
			List<Map<String, Object>> rows = ideAppOpenRepo.findProductAppCount(productIdStr);
			Map<String, Integer> result = new HashMap<String,Integer>();
			for(Map<String, Object> row : rows){
				result.put(row.get("productId").toString(), Integer.parseInt(row.get("appCount").toString()));	
			}
			return result;
		}
		return null;
	}

}
