package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdeDocument;
import com.ejianc.foundation.front.business.ide.repository.IdeDocumentRepo;
import com.ejianc.foundation.front.business.ide.service.IdeDocumentService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Service
@Transactional
public class IdeDocumentServiceImpl implements IdeDocumentService{
	
	@Autowired
	private IdeDocumentRepo ideDocumentRepo;

	@Override
	public void saveOrUpdate(IdeDocument ideDocument) throws BusinessException {
		if(ideDocument.getId() != null && ideDocument.getId() > 0){
			IdeDocument document = ideDocumentRepo.findOne(ideDocument.getId());
			document.setTitle(ideDocument.getTitle());
			document.setLink(ideDocument.getLink());
			document.setDocType(ideDocument.getDocType());
			document.setModifyDate(new Date());
			document.setModifyId(InvocationInfoProxy.getUserid());
			ideDocumentRepo.update(document);
		}else {
			ideDocument.setId(IdWorker.getId());
			ideDocument.setCreateDate(new Date());
			ideDocument.setCreateId(InvocationInfoProxy.getUserid());
			ideDocumentRepo.save(ideDocument);
		}
	}

	@Override
	public List<IdeDocument> findByDocType(int docType) throws BusinessException {
		return ideDocumentRepo.findByType(docType);
	}

	@Override
	public void deleteByIds(String[] ids) throws BusinessException {
		if(ids != null && ids.length > 0) {
			String idStr = "";
			for(String id:ids) {
				idStr += id + ",";
			}
			ideDocumentRepo.logicDel(idStr.substring(0, idStr.length()-1));
		}
		
	}

	@Override
	public List<IdeDocument> findAll() throws BusinessException {
		return ideDocumentRepo.findAll();
	}

}
