package com.ejianc.foundation.front.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
	private static final String[] hexDigits = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d",
			"e", "f" };
	public static final String EMPTY = "";
	public static final String BLANK = " ";

	public static boolean isEmpty(Object obj) {
		return null == obj;
	}

	public static boolean isNull(Object str) {
		return null == str;
	}

	public static String byteArrayToHexString(byte[] b) {
		StringBuffer resultSb = new StringBuffer();
		for (int i = 0; i < b.length; i++) {
			resultSb.append(byteToHexString(b[i]));
		}
		return resultSb.toString();
	}

	public static String byteToHexString(byte b) {
		int n = b;
		if (n < 0) {
			n += 256;
		}
		int d1 = n / 16;
		int d2 = n % 16;
		return hexDigits[d1] + hexDigits[d2];
	}

	public static String MD5Encode(String origin) {
		String resultString = null;
		try {
			resultString = new String(origin);
			MessageDigest md = MessageDigest.getInstance("MD5");
			resultString = byteArrayToHexString(md.digest(resultString.getBytes()));
		} catch (Exception localException) {
		}
		return resultString;
	}

	public static boolean isInvalid(String str1, String str2) {
		boolean flag = true;
		for (int count = 0; count < str1.length(); count++) {
			String temp = str1.substring(count, count + 1);
			if (str2.indexOf(temp, 0) == -1) {
				flag = false;
				break;
			}
		}
		return flag;
	}

	public static double convertToDig(String str) {
		double result = 0.0D;
		int strLen = str.length();
		for (int count = strLen; count > 0; count--) {
			String tempstr = str.substring(strLen - count, strLen - count + 1);
			if (tempstr.equals("0")) {
				result += 0.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("1")) {
				result += 1.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("2")) {
				result += 2.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("3")) {
				result += 3.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("4")) {
				result += 4.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("5")) {
				result += 5.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("6")) {
				result += 6.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("7")) {
				result += 7.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("8")) {
				result += 8.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("9")) {
				result += 9.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("A")) {
				result += 10.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("B")) {
				result += 11.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("C")) {
				result += 12.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("D")) {
				result += 13.0D * Math.pow(16.0D, count - 1);
			} else if (tempstr.equals("E")) {
				result += 14.0D * Math.pow(16.0D, count - 1);
			} else {
				result += 15.0D * Math.pow(16.0D, count - 1);
			}
		}
		return result;
	}

	public static final String transToReportString(String lots) {
		lots = lots.trim();
		String rLots = null;
		String head = null;
		String end = null;
		Integer headI = null;
		Integer endI = null;
		if (lots != null) {
			String[] each = lots.split(",");

			int index = 0;
			for (int i = 0; i < each.length; i++) {
				each[i] = each[i].trim();
				index = each[i].indexOf("~");
				if (index > 0) {
					head = each[i].substring(0, index);
					end = each[i].substring(index + 1, each[i].length());
					headI = Integer.valueOf(head);
					endI = Integer.valueOf(end);
					for (; headI.intValue() <= endI.intValue(); headI = Integer.valueOf(headI.intValue() + 1)) {
						if (rLots == null) {
							rLots = headI.toString() + ",";
						} else {
							rLots = rLots + headI.toString() + ",";
						}
					}
				}
				if (rLots == null) {
					rLots = each[i] + ",";
				} else {
					rLots = rLots + each[i].toString() + ",";
				}
			}
		}
		return rLots;
	}

	public static String replaceZhSpaces(String anyStr) {
		anyStr = anyStr.replaceAll("?", " ");
		return anyStr;
	}

	public static String ClobToString(Clob clob) throws SQLException, IOException {
		String reString = "";
		Reader is = clob.getCharacterStream();
		BufferedReader br = new BufferedReader(is);
		String s = br.readLine();
		StringBuffer sb = new StringBuffer();
		while (s != null) {
			sb.append(s);
			s = br.readLine();
		}
		reString = sb.toString();
		return reString;
	}

	public static String substring(String str, int start, int end) {
		if (str == null) {
			return null;
		}
		if (end < 0) {
			end = str.length() + end;
		}
		if (start < 0) {
			start = str.length() + start;
		}
		if (end > str.length()) {
			end = str.length();
		}
		if (start > end) {
			return "";
		}
		if (start < 0) {
			start = 0;
		}
		if (end < 0) {
			end = 0;
		}
		return str.substring(start, end);
	}

	public static boolean isEmpty(String paramString) {
		return (paramString == null) || (paramString.length() == 0);
	}

	public static boolean isNotEmpty(String paramString) {
		return !isEmpty(paramString);
	}

	public static boolean isBlank(String paramString) {
		int i;
		if ((paramString == null) || ((i = paramString.length()) == 0)) {
			return true;
		}
		for (int j = 0; j < i; j++) {
			if (!Character.isWhitespace(paramString.charAt(j))) {
				return false;
			}
		}
		return true;
	}

	public static boolean isNotBlank(String paramString) {
		return !isBlank(paramString);
	}

	public static String trim(String paramString) {
		return paramString == null ? null : paramString.trim();
	}

	public static String trimToNull(String paramString) {
		String str = trim(paramString);
		return isEmpty(str) ? null : str;
	}

	public static String trimToEmpty(String paramString) {
		return paramString == null ? "" : paramString.trim();
	}

	public static int stringToInt(String paramString) {
		return stringToInt(paramString, 0);
	}

	public static int stringToInt(String paramString, int paramInt) {
		try {
			return Integer.parseInt(paramString);
		} catch (NumberFormatException localNumberFormatException) {
		}
		return paramInt;
	}

	public static String[] matches(String str, String regex, boolean distinct) {
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(str);
		StringBuffer rsb = new StringBuffer();
		while (matcher.find()) {
			rsb.append(matcher.group(0) + "~_~");
		}
		String[] mths = null;
		if (!"".equals(rsb.toString())) {
			mths = rsb.toString().split("~_~");
		}
		if ((mths != null) && (distinct)) {
			mths = array_unique(mths);
		}
		return mths;
	}

	public static String[] array_unique(String[] a) {
		Set<String> set = new HashSet<>();
		set.addAll(Arrays.asList(a));
		return (String[]) set.toArray(new String[0]);
	}

	public static String mergeContent(String template, Map<String, String> variables) {
		if (template == null) {
			return null;
		}
		Set<String> keySet = variables.keySet();
		String mergeResult = template;
		for (String key : keySet) {
			String replaceValue = (String) variables.get(key);
			if (replaceValue != null) {
				String replaceName = "$P{" + key + "}";
				mergeResult = mergeResult.replace(replaceName, replaceValue);
			}
		}
		return mergeResult;
	}

	public static String utf8Encode(String str) {
		if ((!isEmpty(str)) && (str.getBytes().length != str.length())) {
			try {
				return URLEncoder.encode(str, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
			}
		}
		return str;
	}

	public static String utf8Encode(String str, String defultReturn) {
		if ((!isEmpty(str)) && (str.getBytes().length != str.length())) {
			try {
				return URLEncoder.encode(str, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				return defultReturn;
			}
		}
		return str;
	}

	public static List<String> toList(String[] array) {
		List<String> list = new ArrayList<>();
		if ((array != null) && (array.length > 0)) {
			for (String s : array) {
				list.add(s);
			}
		}
		return list;
	}
}
