/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeModuleServiceImpl
implements IdeModuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleServiceImpl.class);
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModuleRepo ideModuleRepoImpl;
    @Autowired
    IdeTeamRepo ideTeamRepo;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModulePrivateService ideModulePrivateService;
    @Autowired
    IdeEnvironmentService ideEnvironmentService;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    private MetadataReaderService metadataReaderService;
    @Autowired
    private ICustomTableApi iCustomTableApi;

    @Override
    public IdeModule saveOrUpdate(IdeModule ideModule) {
        IdeModule ideModuleTemp = null;
        this.setEnData(ideModule);
        if (ideModule.getId() == null) {
            if (StringUtils.isEmpty(String.valueOf(ideModule.getAppId()))) {
                throw new BusinessException("\u6240\u5c5e\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(ideModule.getName())) {
                throw new BusinessException("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<IdeModule> ideModuleList = this.ideModuleRepo.findByName(ideModule.getName(), String.valueOf(ideModule.getAppId()));
            if (ideModuleList.size() > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u9875\u9762\u540d\u79f0");
            }
            ideModule.setId(IdWorker.getId());
            String code = this.ideCommonService.generateModuleCode();
            ideModule.setCode(code);
            Date nowDate = new Date();
            ideModule.setCreateDate(nowDate);
            if (ideModule.isReadEntityMetadata()) {
                JSONObject data = this.metadataReaderService.readMetadata(ideModule.getBillType(), ideModule.getEntityId().toString(), ideModule.getPageType());
                ideModule.setData(data == null ? null : data.toJSONString());
            }
            this.ideModuleRepo.save(ideModule);
            return ideModule;
        }
        ideModuleTemp = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        ideModuleTemp.setTs(new Date().getTime());
        ideModuleTemp.setName(ideModule.getName());
        if (StringUtils.isNotEmpty(ideModule.getClientType())) {
            ideModuleTemp.setClientType(ideModule.getClientType());
        }
        ideModuleTemp.setModifyDate(new Date());
        if (ideModule.getData() != null) {
            ideModuleTemp.setData(ideModule.getData());
            ideModuleTemp.setEnData(ideModule.getEnData());
        }
        if (StringUtils.isNotEmpty(String.valueOf(ideModule.getGroupId()))) {
            ideModuleTemp.setGroupId(ideModule.getGroupId());
        }
        if (ideModuleTemp.getCode().startsWith("CFS") && StringUtils.isNotEmpty(ideModule.getFromName())) {
            Long userId = Long.parseLong(ideModule.getFromName().split(":")[0]);
            String token = ideModule.getFromName().split(":")[1];
            PageData pageData = new PageData();
            pageData.setAppCode(ideModuleTemp.getCode());
            pageData.setPageMeta(ideModule.getData());
            pageData.setToken(token);
            pageData.setUserId(userId);
            CommonResponse response = this.iCustomTableApi.parse(pageData);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            ideModuleTemp.setFromName(null);
        }
        this.ideModuleRepo.update(ideModuleTemp);
        return ideModuleTemp;
    }

    private void setEnData(IdeModule ideModule) {
        if (StringUtils.isNotEmpty(ideModule.getData())) {
            JSONObject data = JSONObject.parseObject((String)ideModule.getData());
            this.setUiTitleEn(data);
            if (data.get((Object)"children") != null && data.getString("children").contains("[")) {
                JSONArray children = data.getJSONArray("children");
                this.setChildrenEn(children);
            }
            ideModule.setEnData(JSONObject.toJSONString((Object)data));
        }
    }

    private void setUiTitleEn(JSONObject ui) {
        if (StringUtils.isNotEmpty(ui.getString("enTitle"))) {
            ui.put("uititle", (Object)ui.getString("enTitle"));
            if (ui.getString("children") != null && !ui.getString("children").contains("[")) {
                ui.put("children", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("title") != null) {
                ui.put("title", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("label") != null) {
                ui.put("label", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("buttonText") != null) {
                ui.put("buttonText", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("text") != null) {
                ui.put("text", (Object)ui.getString("enTitle"));
            }
        }
    }

    private void setChildrenEn(JSONArray children) {
        for (Object child : children) {
            JSONObject ui = (JSONObject)child;
            this.setUiTitleEn(ui);
            if (ui.get((Object)"children") == null || !ui.getString("children").contains("[")) continue;
            JSONArray cChildren = ui.getJSONArray("children");
            this.setChildrenEn(cChildren);
        }
    }

    @Override
    public void copyModule(IdeModule ideModule) throws Exception {
        IdeModule ideModuleSrc = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        IdeModule ideModuleSave = new IdeModule();
        ideModuleSave.setId(IdWorker.getId());
        BeanUtils.copyProperties((Object)ideModuleSrc, (Object)ideModuleSave, (String[])new String[]{"id", "fromId", "fromName", "createId", "createDate", "name"});
        ideModuleSave.setCreateId(ideModule.getCreateId());
        ideModuleSave.setCreateDate(new Date());
        ideModuleSave.setName(ideModule.getName());
        String code = this.ideCommonService.generateModuleCode();
        ideModuleSave.setCode(code);
        ideModuleSave.setAppId(ideModule.getAppId());
        ideModuleSave.setGroupId(ideModule.getGroupId());
        ideModuleSave.setFromId(ideModule.getFromId());
        ideModuleSave.setPageType(ideModule.getPageType());
        ideModuleSave.setFromName(ideModule.getFromName());
        this.ideModuleRepo.save(ideModuleSave);
    }

    @Override
    public IdeModule findByCode(String moduleCode) {
        List<IdeModule> ideModules = this.ideModuleRepo.findAllByCode(moduleCode);
        if (ideModules != null && ideModules.size() > 0) {
            return ideModules.get(0);
        }
        return null;
    }

    @Override
    public List<IdeModule> findByAppId(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findDetailsByAppId(appId);
        return ideModules;
    }

    @Override
    public List<IdeModule> findIsDeleteModules(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findModulesByAppId(appId, 1);
        return ideModules;
    }

    @Override
    public void deleteById(String id) throws Exception {
        this.ideModuleRepo.deleteById(id);
        this.ideModulePrivateRepo.deleteByModuleIds(id);
        IdeModuleData moduleData = this.moduleDataRepo.findByModuleId(Long.parseLong(id));
        if (moduleData != null) {
            this.moduleDataRepo.deleteById(moduleData);
        }
    }

    @Override
    public IdeModuleBo findById(String id) throws Exception {
        IdeModuleBo ideModuleBo = this.ideModuleRepoImpl.findDetailById(id);
        if (ideModuleBo == null) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u5907\u4efd\u7684\u9875\u9762");
        }
        return ideModuleBo;
    }

    @Override
    public IdeModule findEntityById(String id) {
        return this.ideModuleRepo.findById(id);
    }

    @Override
    public IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode) {
        LOGGER.info("findByAppCodeAndModuleCode ======== {{}}---{{}}", (Object)appCode, (Object)moduleCode);
        return this.ideModuleRepo.findByAppCodeAndModuleCode(appCode, moduleCode);
    }

    @Override
    public Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String moduleCode, String orgId, String tenantId) {
        IdeModulePrivate orgPage = null;
        if (orgId != null && !"".equals(orgId) && tenantId != null && !"".equals(tenantId)) {
            orgPage = this.ideModulePrivateService.findByOrgId(moduleCode, appCode, orgId, tenantId);
        }
        LOGGER.info("orgPage ======== " + orgPage);
        if (orgPage != null) {
            return orgPage;
        }
        return this.findByAppCodeAndModuleCode(appCode, moduleCode);
    }

    @Override
    public void publishHistory(IdeModule ideModule, String fromName, String toName) {
        IdeModulePro module = new IdeModulePro();
        BeanUtils.copyProperties((Object)ideModule, (Object)module, (String[])new String[]{"id", "createDate", "modifyDate"});
        module.setCreateDate(new Date());
        module.setFromName(fromName);
        module.setToName(toName);
        int maxVer = this.ideModuleProRepo.findMaxVersion(ideModule.getCode(), toName);
        module.setVerNum(++maxVer);
        module.setId(IdWorker.getId());
        module.setCreateDate(new Date());
        this.ideModuleProRepo.save(module);
    }

    @Override
    public List<IdeModule> findInAppIds(String[] appIds) {
        List<IdeModule> modules = new ArrayList<IdeModule>();
        if (appIds == null || appIds.length == 0) {
            return modules;
        }
        String appIdStr = "'" + org.apache.commons.lang.StringUtils.join(Arrays.asList(appIds), (String)"','") + "'";
        modules = this.ideModuleRepo.findInAppIds(appIdStr);
        return modules;
    }

    @Override
    @Transactional
    public JsonBackData syncPublishProduction(String appId, List<String> pageIds, String fromName, String toName) throws Exception {
        if (StringUtils.isEmpty(toName)) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u53d1\u5e03\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        if (pageIds == null || pageIds.size() == 0) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u6ca1\u6709\u53ef\u53d1\u5e03\u7684\u9875\u9762\uff01");
        }
        IdeApp app = this.ideAppService.findById(appId);
        if (app == null) {
            return JsonBackData.toError("\u53d1\u5e03\u7684\u5e94\u7528[" + appId + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        IdeTeamBo team = null;
        if (app.getTeamId() != null) {
            if (!this.ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
                return JsonBackData.toError("\u672c\u56e2\u961f\u88ab\u9650\u5236\u53d1\u5e03\u5e94\u7528\u5230[" + toName + "]\u73af\u5883\uff0c\u53ef\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01");
            }
            IdeTeam teamBean = this.ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
            if (teamBean != null) {
                team = new IdeTeamBo(teamBean);
            }
        }
        ArrayList<String> notExistPages = new ArrayList<String>();
        List failPages = new ArrayList();
        IdeProductionBo postData = new IdeProductionBo();
        postData.setIdeTeam(team);
        postData.setIdeApp(new IdeAppBo(app));
        postData.setFromName(fromName);
        postData.setToName(toName);
        List<IdeModule> publishModules = new ArrayList<IdeModule>();
        for (String moduleId : pageIds) {
            IdeModule module = this.findEntityById(moduleId);
            if (module == null) {
                notExistPages.add(moduleId);
                continue;
            }
            publishModules.add(module);
        }
        if ((publishModules = this.ideModuleProService.findDiffLastPublish(publishModules, toName)).size() == 0) {
            return JsonBackData.toSuccess("\u6240\u53d1\u5e03\u9875\u9762\u4e0e\u6700\u65b0\u7248\u672c\u76f8\u540c\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03");
        }
        for (IdeModule ideModule : publishModules) {
            postData.getIdeModules().add(new IdeModuleBo(ideModule));
        }
        ObjectMapper mapper = new ObjectMapper();
        String postJson = mapper.writeValueAsString((Object)postData);
        LOGGER.info("\u53d1\u9001\u6570\u636e\uff1a" + postJson);
        HttpResponse httpresponse = HttpClientUtil.postJSON(toName + "/ejc-front-web/ide/production/syncreceive", postJson);
        if (httpresponse == null) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
        }
        int resCode = httpresponse.getStatusLine().getStatusCode();
        if (resCode != 200) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + resCode);
        }
        JSONObject resultObj = null;
        String result = EntityUtils.toString((HttpEntity)httpresponse.getEntity());
        try {
            resultObj = (JSONObject)JSONObject.parse((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(result);
        }
        JsonBackData jsonBackData = new JsonBackData();
        jsonBackData.setSuccess(resultObj.getBoolean("success"));
        jsonBackData.setBackData(resultObj.get((Object)"backData"));
        jsonBackData.setBackMsg(resultObj.getString("backMsg"));
        if (jsonBackData.isSuccess()) {
            for (IdeModule module : publishModules) {
                this.publishHistory(module, fromName, toName);
            }
        } else {
            return jsonBackData;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        failPages = (List)objectMapper.readValue(objectMapper.writeValueAsString(jsonBackData.getBackData()), (TypeReference)new TypeReference<ArrayList<String>>(){});
        if (notExistPages.size() > 0 || failPages.size() > 0) {
            HashMap<String, Object> backData = new HashMap<String, Object>();
            backData.put("notExist", notExistPages.size());
            backData.put("failPages", failPages);
            return JsonBackData.toSuccess("\u53d1\u5e03\u5b8c\u6210", backData);
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f");
    }

    @Override
    @Transactional
    public JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception {
        IdeAppBo appBo;
        IdeApp ideApp;
        LOGGER.info("\u63a5\u6536\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)production));
        IdeTeamBo teamBo = production.getIdeTeam();
        IdeTeam ideTeam = null;
        if (teamBo != null) {
            ideTeam = this.ideTeamRepo.findOne(teamBo.getId());
            if (ideTeam == null) {
                ideTeam = new IdeTeam();
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                ideTeam.setId(Long.parseLong(teamBo.getId()));
                LOGGER.info("ideTeam==null \u6ca1\u627e\u5230\u65b0\u5efateam\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.save(ideTeam);
            } else {
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                LOGGER.info("\u627e\u5230team,\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.update(ideTeam);
            }
        }
        if ((ideApp = this.ideAppRepo.findById((appBo = production.getIdeApp()).getId())) != null) {
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp);
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u627e\u5230ideApp\uff0c\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.update(ideApp);
        } else {
            ideApp = new IdeApp();
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp, (String[])new String[]{"modifyDate"});
            ideApp.setId(Long.parseLong(appBo.getId()));
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u6ca1\u627e\u5230ideApp\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.save(ideApp);
        }
        List<IdeModuleBo> moduleBos = production.getIdeModules();
        LOGGER.info("\u63a5\u6536\u5230\u9875\u9762\uff1a" + JSONObject.toJSONString(moduleBos));
        ArrayList<String> failPages = new ArrayList<String>();
        if (moduleBos != null && moduleBos.size() > 0) {
            for (IdeModuleBo moduleBo : moduleBos) {
                try {
                    IdeModule ideModule = this.ideModuleRepo.findById(moduleBo.getId());
                    if (ideModule == null || ideModule.getId() == null) {
                        ideModule = new IdeModule();
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setId(Long.parseLong(moduleBo.getId()));
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c:\u6ca1\u627e\u5230\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.save(ideModule);
                    } else {
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c\u627e\u5230\u4e86:\u66f4\u65b0" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.update(ideModule);
                    }
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....");
                    this.publishHistory(ideModule, production.getFromName(), production.getToName());
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....\u6210\u529f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage() + "  \u9875\u9762\uff1a[" + moduleBo.getCode() + "]" + moduleBo.getName());
                    failPages.add("[" + moduleBo.getCode() + "]" + moduleBo.getName());
                }
            }
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f", failPages);
    }

    @Override
    public Page<IdeModule> findModulesByAppId(String appId, String searchText, boolean isDelete, Pageable pageable) throws Exception {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        List<IdeModule> ideModules = this.ideModuleRepo.findModuleListByAppId(appId, searchText, isDelete, pageIndex, pageable.getPageSize());
        Long total = this.ideModuleRepo.findModuleCountByAppId(appId, searchText, isDelete);
        PageImpl page = new PageImpl(ideModules, pageable, total.longValue());
        return page;
    }

    @Override
    public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
        String moduleIds = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                moduleIds = moduleIds + id + ",";
            }
            moduleIds = moduleIds.substring(0, moduleIds.length() - 1);
            List<IdeModulePrivate> modulePrivates = this.ideModulePrivateRepo.findListByModuleIds(moduleIds);
            return modulePrivates;
        }
        return null;
    }

    @Override
    public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
        String idStr = "";
        for (String id : ids) {
            idStr = idStr + id + ",";
        }
        if (StringUtils.isNotEmpty(idStr)) {
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        if (isRemove) {
            this.ideModuleRepo.removeByIds(idStr);
            this.ideModulePrivateRepo.removeByModuleIds(idStr);
        } else {
            this.ideModuleRepo.deleteByIds(idStr);
            this.moduleDataRepo.deleteByModuleIds(idStr);
            this.ideModulePrivateRepo.deleteByModuleIds(idStr);
        }
    }

    @Override
    public void restoreByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.ideModuleRepo.recoverByIds(idStr);
            this.ideModulePrivateRepo.recoverByModuleIds(idStr);
        }
    }

    @Override
    public JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException, Exception {
        if (pageIds != null && pageIds.size() > 0) {
            String pageIdStr = "";
            for (String pageId : pageIds) {
                pageIdStr = pageIdStr + pageId + ",";
            }
            pageIdStr = pageIdStr.substring(0, pageIdStr.length() - 1);
            this.ideModuleRepo.movePagesByAppId(pageIdStr, appId);
        }
        return JsonBackData.toSuccess("\u8fc1\u79fb\u6210\u529f");
    }

    @Override
    public List<IdeModule> findByIds(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            String idStr = "";
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            return this.ideModuleRepo.findByIds(idStr);
        }
        return null;
    }
}

