package com.ejianc.foundation.front.business.ide.controller;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.service.IdeReleaseService;
import com.ejianc.foundation.front.util.JsonBackData;

@Controller
@RequestMapping(value = "ide/release")
public class IdeReleaseController {
    private static final Logger log = LoggerFactory.getLogger(IdeReleaseController.class);

    @Autowired
    private IdeReleaseService releaseService;

    @SuppressWarnings("unchecked")
	@ResponseBody
    @RequestMapping(value = "release" ,method = RequestMethod.POST)
    public JsonBackData release(@RequestBody Map<String, Object> params) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        String version = (String) params.get("version");
        Map<String, Object> appList = (Map<String, Object>) params.get("appList");
        try {
        	releaseService.releaseAppIds(appList, version);
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("发版失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "findReleases" ,method = RequestMethod.GET)
    public JsonBackData findReleases(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.findReleases(appId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("获取版本列表失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "findReleasePages" ,method = RequestMethod.GET)
    public JsonBackData findReleasePages(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.findReleasePages(releaseGroupId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("获取发版页面列表失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "online" ,method = RequestMethod.GET)
    public JsonBackData online(String releaseGroupId, String envUrl) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            releaseService.online(releaseGroupId, envUrl);
        } catch (Exception e) {
            log.error("上线失败！", e);
            back.setSuccess(false);
            back.setBackMsg("上线失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "viewOnlineHistory" ,method = RequestMethod.GET)
    public JsonBackData viewOnlineHistory(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.viewOnlineHistory(appId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("查看上线历史记录失败" + e.getMessage());
        }
        return back;
    }
    
    @ResponseBody
    @RequestMapping(value = "deleteVersion" ,method = RequestMethod.GET)
    public JsonBackData deleteVersion(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            releaseService.deleteVersion(releaseGroupId);
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("查看上线历史记录失败" + e.getMessage());
        }
        return back;
    }
}
