package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.entity.IdePartWidget;
import com.ejianc.foundation.front.business.ide.service.IdePartWidgetService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * Created by wuhao on 2016/11/15.
 */
@SuppressWarnings("finally")
@RestController
//@RequestMapping(value = "/designpage/widget")
@RequestMapping(value = "/ide/partwidget")
public class IdePartWidgetController {

    @Autowired
    IdePartWidgetService idePartWidgetService;

    /**
     * 保存、修改和删除都调用此接口，更新 idePartWidget.data 字段
     * @param idePartWidget
     * @return
     */
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData saveOrUpdate(@RequestBody IdePartWidget idePartWidget){
        JsonBackData backData = new JsonBackData();
        try {
            IdePartWidget idePartWidgetNew = idePartWidgetService.saveOrUpdate(idePartWidget);
            backData.setBackData(idePartWidgetNew);
            backData.setBackMsg("成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        } finally {
            return backData;
        }
    }

    
	@RequestMapping(value="{userId}",method = RequestMethod.GET)
    public JsonBackData findByCreateId(@PathVariable String userId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdePartWidget> idePartWidgetList = idePartWidgetService.findByCreateId(userId);
            backData.setBackData(idePartWidgetList);
            backData.setBackMsg("成功");
        } catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("系统错误");
            backData.setSuccess(false);
        } finally {
            return backData;
        }
    }
    
	@RequestMapping(value="delete",method=RequestMethod.DELETE)
    public JsonBackData deleteById(@RequestBody IdePartWidget idePartWidget ){
    	JsonBackData backData = new JsonBackData();
    	try {
    		List<IdePartWidget> res =idePartWidgetService.deleteById(idePartWidget);
			backData.setBackData(res);
			backData.setBackMsg("成功");
		} catch (Exception e) {
			e.printStackTrace();
			backData.setBackMsg("系统错误");
			backData.setSuccess(false);
		}finally {
			return backData;
		}
		
    }

}
