package com.ejianc.foundation.front.business.ide.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;
import com.ejianc.foundation.front.business.ide.service.IdeResourceService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 模块数据模型controller
 */
@RestController
@RequestMapping(value = "/ide/resource")
public class IdeResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeResourceController.class);
    @Autowired
    private IdeResourceService resourceService;

    /**
     * 保存模块数据模型
     *
     * @param resource 模块数据模型
     * @return {@link JsonBackData}
     */
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(resourceService.save(resource));
            backData.setBackMsg("保存模块数据模型成功");
        } catch (BusinessException e) {
            LOGGER.error("保存模块数据模型失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("保存模块数据模型失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("保存模块数据模型失败");
        }
        return backData;
    }

    /**
     * 获取模块数据模型
     *
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public JsonBackData get(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(resourceService.findById(id));
            backData.setBackMsg("获取模块数据模型成功");
        } catch (BusinessException e) {
            LOGGER.error("获取模块数据模型失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取模块数据模型失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("获取模块数据模型失败");
        }
        return backData;
    }

    /**
     * 删除模块数据模型
     *
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            resourceService.deleteById(id);
            backData.setBackMsg("删除模块数据模型成功");
        } catch (BusinessException e) {
            LOGGER.error("删除模块数据模型失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("删除模块数据模型失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("删除模块数据模型失败");
        }
        return backData;
    }

    /**
     * 查找模块数据模型列表
     *
     * @param appId 应用id
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "find/{appId}", method = RequestMethod.GET)
    public JsonBackData module(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(resourceService.findByAppId(appId));
            backData.setBackMsg("查找模块数据模型列表成功");
        } catch (BusinessException e) {
            LOGGER.error("查找模块数据模型列表失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("查找模块数据模型列表失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("查找模块数据模型列表失败");
        }
        return backData;
    }

    /**
     * 更改资源名称
     *
     * @param resource 模块数据模型
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "updateName", method = RequestMethod.POST)
    public JsonBackData updateName(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(resourceService.updateName(String.valueOf(resource.getCreateId()), String.valueOf(resource.getId()), resource.getName(), resource.getVersion()));
            backData.setBackMsg("更改资源名称成功");
        } catch (BusinessException e) {
            LOGGER.error("更改资源名称失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("更改资源名称失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("更改资源名称失败");
        }
        return backData;
    }

    /**
     * 更改资源数据
     *
     * @param resource 模块数据模型
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "updateData", method = RequestMethod.POST)
    public JsonBackData updateData(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(resourceService.updateData(String.valueOf(resource.getCreateId()), String.valueOf(resource.getId()), resource.getData(), resource.getVersion()));
            backData.setBackMsg("更改资源数据成功");
        } catch (BusinessException e) {
            LOGGER.error("更改资源数据失败：", e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("更改资源数据失败", e);
            backData.setSuccess(false);
            backData.setBackMsg("更改资源数据失败");
        }
        return backData;
    }
    
    @RequestMapping(value="getData/{appCode}/{resourceCode}",method = RequestMethod.GET)
    public JsonBackData findByAppCodeAndResourceCode(@PathVariable String appCode,@PathVariable String resourceCode) {
        try {
        	IdeResource bean = resourceService.findByAppCodeAndResourceCode(appCode,resourceCode);	
            return JsonBackData.toSuccess("获取资源成功", bean);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
}
