package com.ejianc.foundation.front.business.ide.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.service.IdeTeamService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@SuppressWarnings("deprecation")
@Controller
@RequestMapping(value = "ide/ideTeamMgr")
public class IdeTeamMgrController {
	
	@Autowired
	private IdeTeamService ideTeamService;
	
	@ResponseBody
	@RequestMapping(value = "showList" ,method = RequestMethod.POST)
	public JsonBackData showList(@RequestBody Map<String, Object> query) {
		JsonBackData back = new JsonBackData();
		int pageNumber = (Integer) query.get("pageNumber");
		int pageSize = (Integer) query.get("pageSize");
		String searchText = (String) query.get("searchText");
		boolean isDelete = (boolean) query.get("isDelete");
		int prodType = ((Integer) query.get("prodType"))!= null?((Integer) query.get("prodType")):0;
		try {
			Pageable pageable = null;
			pageable = new PageRequest(pageNumber <= 0 ? 0 :pageNumber, pageSize);
			back.setBackData(ideTeamService.findPage(searchText,prodType,isDelete,pageable));
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	@ResponseBody
	@RequestMapping(value = "showAllTeam")
	public JsonBackData showAllTeam() {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideTeamService.findTeamByProdType(0));
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "delete",method = RequestMethod.POST)
	public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query){
		JsonBackData back = new JsonBackData();
		List<String> ids = (List<String>) query.get("ids");
		boolean isRemove = (boolean) query.get("isRemove");
		try {
			ideTeamService.deleteByIds(ids, isRemove);;
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "restore",method = RequestMethod.POST)
	public JsonBackData restoreByIds(@RequestBody Map<String, Object> query){
		JsonBackData back = new JsonBackData();
		List<String> ids = (List<String>) query.get("ids");
		try {
			ideTeamService.recoverByIds(ids);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
}
